/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayPathRuleInner;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayRequestRoutingRuleInner;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayUrlPathMapInner;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayBackendImpl;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayImpl;
import com.azure.resourcemanager.network.implementation.ApplicationGatewayPathRuleImpl;
import com.azure.resourcemanager.network.models.ApplicationGateway;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackend;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendHttpConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewayPathRule;
import com.azure.resourcemanager.network.models.ApplicationGatewayRedirectConfiguration;
import com.azure.resourcemanager.network.models.ApplicationGatewayUrlPathMap;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.ChildResourceImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class ApplicationGatewayUrlPathMapImpl
extends ChildResourceImpl<ApplicationGatewayUrlPathMapInner, ApplicationGatewayImpl, ApplicationGateway>
implements ApplicationGatewayUrlPathMap,
ApplicationGatewayUrlPathMap.Definition<ApplicationGateway.DefinitionStages.WithRequestRoutingRuleOrCreate>,
ApplicationGatewayUrlPathMap.UpdateDefinition<ApplicationGateway.Update>,
ApplicationGatewayUrlPathMap.Update {
    private Map<String, ApplicationGatewayPathRule> pathRules;

    ApplicationGatewayUrlPathMapImpl(ApplicationGatewayUrlPathMapInner inner, ApplicationGatewayImpl parent) {
        super((Object)inner, (Object)parent);
        this.initializePathRules();
    }

    private void initializePathRules() {
        this.pathRules = new HashMap<String, ApplicationGatewayPathRule>();
        if (((ApplicationGatewayUrlPathMapInner)((Object)this.innerModel())).pathRules() != null) {
            for (ApplicationGatewayPathRuleInner inner : ((ApplicationGatewayUrlPathMapInner)((Object)this.innerModel())).pathRules()) {
                this.pathRules.put(inner.name(), new ApplicationGatewayPathRuleImpl(inner, this));
            }
        }
    }

    public String name() {
        return ((ApplicationGatewayUrlPathMapInner)((Object)this.innerModel())).name();
    }

    @Override
    public Map<String, ApplicationGatewayPathRule> pathRules() {
        return Collections.unmodifiableMap(this.pathRules);
    }

    @Override
    public ApplicationGatewayBackend defaultBackend() {
        SubResource backendRef = ((ApplicationGatewayUrlPathMapInner)((Object)this.innerModel())).defaultBackendAddressPool();
        return backendRef != null ? ((ApplicationGatewayImpl)this.parent()).backends().get(ResourceUtils.nameFromResourceId((String)backendRef.id())) : null;
    }

    @Override
    public ApplicationGatewayBackendHttpConfiguration defaultBackendHttpConfiguration() {
        SubResource backendHttpConfigRef = ((ApplicationGatewayUrlPathMapInner)((Object)this.innerModel())).defaultBackendHttpSettings();
        return backendHttpConfigRef != null ? ((ApplicationGatewayImpl)this.parent()).backendHttpConfigurations().get(ResourceUtils.nameFromResourceId((String)backendHttpConfigRef.id())) : null;
    }

    @Override
    public ApplicationGatewayRedirectConfiguration defaultRedirectConfiguration() {
        SubResource redirectRef = ((ApplicationGatewayUrlPathMapInner)((Object)this.innerModel())).defaultRedirectConfiguration();
        return redirectRef != null ? ((ApplicationGatewayImpl)this.parent()).redirectConfigurations().get(ResourceUtils.nameFromResourceId((String)redirectRef.id())) : null;
    }

    public ApplicationGatewayImpl attach() {
        return ((ApplicationGatewayImpl)this.parent()).withUrlPathMap(this);
    }

    public ApplicationGatewayUrlPathMapImpl toBackendHttpConfiguration(String name) {
        SubResource httpConfigRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/backendHttpSettingsCollection/" + name);
        ((ApplicationGatewayUrlPathMapInner)((Object)this.innerModel())).withDefaultBackendHttpSettings(httpConfigRef);
        return this;
    }

    public ApplicationGatewayUrlPathMapImpl toBackendHttpPort(int portNumber) {
        String name = ((NetworkManager)((ApplicationGatewayImpl)this.parent()).manager()).resourceManager().internalContext().randomResourceName("backcfg", 12);
        ((ApplicationGatewayImpl)this.parent()).defineBackendHttpConfiguration(name).withPort(portNumber).attach();
        return this.toBackendHttpConfiguration(name);
    }

    public ApplicationGatewayUrlPathMapImpl toBackend(String name) {
        ((ApplicationGatewayUrlPathMapInner)((Object)this.innerModel())).withDefaultBackendAddressPool(((ApplicationGatewayImpl)this.parent()).ensureBackendRef(name));
        return this;
    }

    public ApplicationGatewayUrlPathMapImpl withRedirectConfiguration(String name) {
        if (name == null) {
            ((ApplicationGatewayUrlPathMapInner)((Object)this.innerModel())).withDefaultRedirectConfiguration(null);
        } else {
            SubResource ref = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/redirectConfigurations/" + name);
            ((ApplicationGatewayUrlPathMapInner)((Object)this.innerModel())).withDefaultRedirectConfiguration(ref).withDefaultBackendAddressPool(null).withDefaultBackendHttpSettings(null);
        }
        return this;
    }

    public ApplicationGatewayPathRuleImpl definePathRule(String name) {
        return new ApplicationGatewayPathRuleImpl(new ApplicationGatewayPathRuleInner().withName(name), this);
    }

    ApplicationGatewayUrlPathMapImpl withPathRule(ApplicationGatewayPathRuleImpl pathRule) {
        if (pathRule != null) {
            if (((ApplicationGatewayUrlPathMapInner)((Object)this.innerModel())).pathRules() == null) {
                ((ApplicationGatewayUrlPathMapInner)((Object)this.innerModel())).withPathRules(new ArrayList<ApplicationGatewayPathRuleInner>());
            }
            ((ApplicationGatewayUrlPathMapInner)((Object)this.innerModel())).pathRules().add((ApplicationGatewayPathRuleInner)((Object)pathRule.innerModel()));
        }
        return this;
    }

    public ApplicationGatewayUrlPathMapImpl fromListener(String name) {
        SubResource listenerRef = new SubResource().withId(((ApplicationGatewayImpl)this.parent()).futureResourceId() + "/HTTPListeners/" + name);
        ((ApplicationGatewayRequestRoutingRuleInner)((Object)((ApplicationGatewayImpl)this.parent()).requestRoutingRules().get(this.name()).innerModel())).withHttpListener(listenerRef);
        return this;
    }

    public ApplicationGatewayUrlPathMapImpl toBackendIPAddress(String ipAddress) {
        ((ApplicationGatewayImpl)this.parent()).updateBackend(this.ensureBackend().name()).withIPAddress(ipAddress);
        return this;
    }

    public ApplicationGatewayUrlPathMapImpl toBackendIPAddresses(String ... ipAddresses) {
        if (ipAddresses != null) {
            for (String ipAddress : ipAddresses) {
                this.toBackendIPAddress(ipAddress);
            }
        }
        return this;
    }

    public ApplicationGatewayUrlPathMapImpl toBackendFqdn(String fqdn) {
        ((ApplicationGatewayImpl)this.parent()).updateBackend(this.ensureBackend().name()).withFqdn(fqdn);
        return this;
    }

    private ApplicationGatewayBackendImpl ensureBackend() {
        ApplicationGatewayBackendImpl backend = (ApplicationGatewayBackendImpl)this.defaultBackend();
        if (backend == null) {
            backend = ((ApplicationGatewayImpl)this.parent()).ensureUniqueBackend();
            this.toBackend(backend.name());
        }
        return backend;
    }
}

