/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.DisableBgpRoutePropagation;
import com.azure.resourcemanager.network.models.NetworkManagerRoutingGroupItem;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class RoutingRuleCollectionPropertiesFormat
implements JsonSerializable<RoutingRuleCollectionPropertiesFormat> {
    private String description;
    private ProvisioningState provisioningState;
    private String resourceGuid;
    private List<NetworkManagerRoutingGroupItem> appliesTo;
    private DisableBgpRoutePropagation disableBgpRoutePropagation;
    private static final ClientLogger LOGGER = new ClientLogger(RoutingRuleCollectionPropertiesFormat.class);

    public String description() {
        return this.description;
    }

    public RoutingRuleCollectionPropertiesFormat withDescription(String description) {
        this.description = description;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public List<NetworkManagerRoutingGroupItem> appliesTo() {
        return this.appliesTo;
    }

    public RoutingRuleCollectionPropertiesFormat withAppliesTo(List<NetworkManagerRoutingGroupItem> appliesTo) {
        this.appliesTo = appliesTo;
        return this;
    }

    public DisableBgpRoutePropagation disableBgpRoutePropagation() {
        return this.disableBgpRoutePropagation;
    }

    public RoutingRuleCollectionPropertiesFormat withDisableBgpRoutePropagation(DisableBgpRoutePropagation disableBgpRoutePropagation) {
        this.disableBgpRoutePropagation = disableBgpRoutePropagation;
        return this;
    }

    public void validate() {
        if (this.appliesTo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property appliesTo in model RoutingRuleCollectionPropertiesFormat"));
        }
        this.appliesTo().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("appliesTo", this.appliesTo, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("disableBgpRoutePropagation", this.disableBgpRoutePropagation == null ? null : this.disableBgpRoutePropagation.toString());
        return jsonWriter.writeEndObject();
    }

    public static RoutingRuleCollectionPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (RoutingRuleCollectionPropertiesFormat)jsonReader.readObject(reader -> {
            RoutingRuleCollectionPropertiesFormat deserializedRoutingRuleCollectionPropertiesFormat = new RoutingRuleCollectionPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("appliesTo".equals(fieldName)) {
                    List appliesTo;
                    deserializedRoutingRuleCollectionPropertiesFormat.appliesTo = appliesTo = reader.readArray(reader1 -> NetworkManagerRoutingGroupItem.fromJson(reader1));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRoutingRuleCollectionPropertiesFormat.description = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedRoutingRuleCollectionPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedRoutingRuleCollectionPropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                if ("disableBgpRoutePropagation".equals(fieldName)) {
                    deserializedRoutingRuleCollectionPropertiesFormat.disableBgpRoutePropagation = DisableBgpRoutePropagation.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRoutingRuleCollectionPropertiesFormat;
        });
    }
}

