/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NspAssociationProperties;
import com.azure.resourcemanager.network.models.AssociationAccessMode;
import com.azure.resourcemanager.network.models.NspProvisioningState;
import com.azure.resourcemanager.network.models.SecurityPerimeterProxyResource;
import com.azure.resourcemanager.network.models.SecurityPerimeterSystemData;
import java.io.IOException;

public final class NspAssociationInner
extends SecurityPerimeterProxyResource {
    private NspAssociationProperties innerProperties;
    private SecurityPerimeterSystemData systemData;
    private String type;
    private String name;
    private String id;

    private NspAssociationProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public SecurityPerimeterSystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    public NspProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public SubResource privateLinkResource() {
        return this.innerProperties() == null ? null : this.innerProperties().privateLinkResource();
    }

    public NspAssociationInner withPrivateLinkResource(SubResource privateLinkResource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAssociationProperties();
        }
        this.innerProperties().withPrivateLinkResource(privateLinkResource);
        return this;
    }

    public SubResource profile() {
        return this.innerProperties() == null ? null : this.innerProperties().profile();
    }

    public NspAssociationInner withProfile(SubResource profile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAssociationProperties();
        }
        this.innerProperties().withProfile(profile);
        return this;
    }

    public AssociationAccessMode accessMode() {
        return this.innerProperties() == null ? null : this.innerProperties().accessMode();
    }

    public NspAssociationInner withAccessMode(AssociationAccessMode accessMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NspAssociationProperties();
        }
        this.innerProperties().withAccessMode(accessMode);
        return this;
    }

    public String hasProvisioningIssues() {
        return this.innerProperties() == null ? null : this.innerProperties().hasProvisioningIssues();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static NspAssociationInner fromJson(JsonReader jsonReader) throws IOException {
        return (NspAssociationInner)((Object)jsonReader.readObject(reader -> {
            NspAssociationInner deserializedNspAssociationInner = new NspAssociationInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedNspAssociationInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedNspAssociationInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedNspAssociationInner.type = reader.getString();
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedNspAssociationInner.systemData = SecurityPerimeterSystemData.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedNspAssociationInner.innerProperties = NspAssociationProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNspAssociationInner;
        }));
    }
}

