/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ContainerNetworkInterface;
import com.azure.resourcemanager.network.models.ContainerNetworkInterfaceConfiguration;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class NetworkProfilePropertiesFormat
implements JsonSerializable<NetworkProfilePropertiesFormat> {
    private List<ContainerNetworkInterface> containerNetworkInterfaces;
    private List<ContainerNetworkInterfaceConfiguration> containerNetworkInterfaceConfigurations;
    private String resourceGuid;
    private ProvisioningState provisioningState;

    public List<ContainerNetworkInterface> containerNetworkInterfaces() {
        return this.containerNetworkInterfaces;
    }

    public List<ContainerNetworkInterfaceConfiguration> containerNetworkInterfaceConfigurations() {
        return this.containerNetworkInterfaceConfigurations;
    }

    public NetworkProfilePropertiesFormat withContainerNetworkInterfaceConfigurations(List<ContainerNetworkInterfaceConfiguration> containerNetworkInterfaceConfigurations) {
        this.containerNetworkInterfaceConfigurations = containerNetworkInterfaceConfigurations;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.containerNetworkInterfaces() != null) {
            this.containerNetworkInterfaces().forEach(e -> e.validate());
        }
        if (this.containerNetworkInterfaceConfigurations() != null) {
            this.containerNetworkInterfaceConfigurations().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("containerNetworkInterfaceConfigurations", this.containerNetworkInterfaceConfigurations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static NetworkProfilePropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkProfilePropertiesFormat)jsonReader.readObject(reader -> {
            NetworkProfilePropertiesFormat deserializedNetworkProfilePropertiesFormat = new NetworkProfilePropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("containerNetworkInterfaces".equals(fieldName)) {
                    List containerNetworkInterfaces;
                    deserializedNetworkProfilePropertiesFormat.containerNetworkInterfaces = containerNetworkInterfaces = reader.readArray(reader1 -> ContainerNetworkInterface.fromJson(reader1));
                    continue;
                }
                if ("containerNetworkInterfaceConfigurations".equals(fieldName)) {
                    List containerNetworkInterfaceConfigurations;
                    deserializedNetworkProfilePropertiesFormat.containerNetworkInterfaceConfigurations = containerNetworkInterfaceConfigurations = reader.readArray(reader1 -> ContainerNetworkInterfaceConfiguration.fromJson(reader1));
                    continue;
                }
                if ("resourceGuid".equals(fieldName)) {
                    deserializedNetworkProfilePropertiesFormat.resourceGuid = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedNetworkProfilePropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkProfilePropertiesFormat;
        });
    }
}

