/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ExpressRouteServiceProviderBandwidthsOffered;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;
import java.util.List;

public final class ExpressRouteServiceProviderPropertiesFormat
implements JsonSerializable<ExpressRouteServiceProviderPropertiesFormat> {
    private List<String> peeringLocations;
    private List<ExpressRouteServiceProviderBandwidthsOffered> bandwidthsOffered;
    private ProvisioningState provisioningState;

    public List<String> peeringLocations() {
        return this.peeringLocations;
    }

    public ExpressRouteServiceProviderPropertiesFormat withPeeringLocations(List<String> peeringLocations) {
        this.peeringLocations = peeringLocations;
        return this;
    }

    public List<ExpressRouteServiceProviderBandwidthsOffered> bandwidthsOffered() {
        return this.bandwidthsOffered;
    }

    public ExpressRouteServiceProviderPropertiesFormat withBandwidthsOffered(List<ExpressRouteServiceProviderBandwidthsOffered> bandwidthsOffered) {
        this.bandwidthsOffered = bandwidthsOffered;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.bandwidthsOffered() != null) {
            this.bandwidthsOffered().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("peeringLocations", this.peeringLocations, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("bandwidthsOffered", this.bandwidthsOffered, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static ExpressRouteServiceProviderPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return (ExpressRouteServiceProviderPropertiesFormat)jsonReader.readObject(reader -> {
            ExpressRouteServiceProviderPropertiesFormat deserializedExpressRouteServiceProviderPropertiesFormat = new ExpressRouteServiceProviderPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("peeringLocations".equals(fieldName)) {
                    List peeringLocations;
                    deserializedExpressRouteServiceProviderPropertiesFormat.peeringLocations = peeringLocations = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("bandwidthsOffered".equals(fieldName)) {
                    List bandwidthsOffered;
                    deserializedExpressRouteServiceProviderPropertiesFormat.bandwidthsOffered = bandwidthsOffered = reader.readArray(reader1 -> ExpressRouteServiceProviderBandwidthsOffered.fromJson(reader1));
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedExpressRouteServiceProviderPropertiesFormat.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExpressRouteServiceProviderPropertiesFormat;
        });
    }
}

