// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * VPN client connection health detail.
 */
@Immutable
public final class VpnClientConnectionHealthDetail implements JsonSerializable<VpnClientConnectionHealthDetail> {
    /*
     * The vpn client Id.
     */
    private String vpnConnectionId;

    /*
     * The duration time of a connected vpn client.
     */
    private Long vpnConnectionDuration;

    /*
     * The start time of a connected vpn client.
     */
    private String vpnConnectionTime;

    /*
     * The public Ip of a connected vpn client.
     */
    private String publicIpAddress;

    /*
     * The assigned private Ip of a connected vpn client.
     */
    private String privateIpAddress;

    /*
     * The user name of a connected vpn client.
     */
    private String vpnUsername;

    /*
     * The max band width.
     */
    private Long maxBandwidth;

    /*
     * The egress packets per second.
     */
    private Long egressPacketsTransferred;

    /*
     * The egress bytes per second.
     */
    private Long egressBytesTransferred;

    /*
     * The ingress packets per second.
     */
    private Long ingressPacketsTransferred;

    /*
     * The ingress bytes per second.
     */
    private Long ingressBytesTransferred;

    /*
     * The max packets transferred per second.
     */
    private Long maxPacketsPerSecond;

    /**
     * Creates an instance of VpnClientConnectionHealthDetail class.
     */
    public VpnClientConnectionHealthDetail() {
    }

    /**
     * Get the vpnConnectionId property: The vpn client Id.
     * 
     * @return the vpnConnectionId value.
     */
    public String vpnConnectionId() {
        return this.vpnConnectionId;
    }

    /**
     * Get the vpnConnectionDuration property: The duration time of a connected vpn client.
     * 
     * @return the vpnConnectionDuration value.
     */
    public Long vpnConnectionDuration() {
        return this.vpnConnectionDuration;
    }

    /**
     * Get the vpnConnectionTime property: The start time of a connected vpn client.
     * 
     * @return the vpnConnectionTime value.
     */
    public String vpnConnectionTime() {
        return this.vpnConnectionTime;
    }

    /**
     * Get the publicIpAddress property: The public Ip of a connected vpn client.
     * 
     * @return the publicIpAddress value.
     */
    public String publicIpAddress() {
        return this.publicIpAddress;
    }

    /**
     * Get the privateIpAddress property: The assigned private Ip of a connected vpn client.
     * 
     * @return the privateIpAddress value.
     */
    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    /**
     * Get the vpnUsername property: The user name of a connected vpn client.
     * 
     * @return the vpnUsername value.
     */
    public String vpnUsername() {
        return this.vpnUsername;
    }

    /**
     * Get the maxBandwidth property: The max band width.
     * 
     * @return the maxBandwidth value.
     */
    public Long maxBandwidth() {
        return this.maxBandwidth;
    }

    /**
     * Get the egressPacketsTransferred property: The egress packets per second.
     * 
     * @return the egressPacketsTransferred value.
     */
    public Long egressPacketsTransferred() {
        return this.egressPacketsTransferred;
    }

    /**
     * Get the egressBytesTransferred property: The egress bytes per second.
     * 
     * @return the egressBytesTransferred value.
     */
    public Long egressBytesTransferred() {
        return this.egressBytesTransferred;
    }

    /**
     * Get the ingressPacketsTransferred property: The ingress packets per second.
     * 
     * @return the ingressPacketsTransferred value.
     */
    public Long ingressPacketsTransferred() {
        return this.ingressPacketsTransferred;
    }

    /**
     * Get the ingressBytesTransferred property: The ingress bytes per second.
     * 
     * @return the ingressBytesTransferred value.
     */
    public Long ingressBytesTransferred() {
        return this.ingressBytesTransferred;
    }

    /**
     * Get the maxPacketsPerSecond property: The max packets transferred per second.
     * 
     * @return the maxPacketsPerSecond value.
     */
    public Long maxPacketsPerSecond() {
        return this.maxPacketsPerSecond;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnClientConnectionHealthDetail from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnClientConnectionHealthDetail if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnClientConnectionHealthDetail.
     */
    public static VpnClientConnectionHealthDetail fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnClientConnectionHealthDetail deserializedVpnClientConnectionHealthDetail
                = new VpnClientConnectionHealthDetail();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vpnConnectionId".equals(fieldName)) {
                    deserializedVpnClientConnectionHealthDetail.vpnConnectionId = reader.getString();
                } else if ("vpnConnectionDuration".equals(fieldName)) {
                    deserializedVpnClientConnectionHealthDetail.vpnConnectionDuration
                        = reader.getNullable(JsonReader::getLong);
                } else if ("vpnConnectionTime".equals(fieldName)) {
                    deserializedVpnClientConnectionHealthDetail.vpnConnectionTime = reader.getString();
                } else if ("publicIpAddress".equals(fieldName)) {
                    deserializedVpnClientConnectionHealthDetail.publicIpAddress = reader.getString();
                } else if ("privateIpAddress".equals(fieldName)) {
                    deserializedVpnClientConnectionHealthDetail.privateIpAddress = reader.getString();
                } else if ("vpnUserName".equals(fieldName)) {
                    deserializedVpnClientConnectionHealthDetail.vpnUsername = reader.getString();
                } else if ("maxBandwidth".equals(fieldName)) {
                    deserializedVpnClientConnectionHealthDetail.maxBandwidth = reader.getNullable(JsonReader::getLong);
                } else if ("egressPacketsTransferred".equals(fieldName)) {
                    deserializedVpnClientConnectionHealthDetail.egressPacketsTransferred
                        = reader.getNullable(JsonReader::getLong);
                } else if ("egressBytesTransferred".equals(fieldName)) {
                    deserializedVpnClientConnectionHealthDetail.egressBytesTransferred
                        = reader.getNullable(JsonReader::getLong);
                } else if ("ingressPacketsTransferred".equals(fieldName)) {
                    deserializedVpnClientConnectionHealthDetail.ingressPacketsTransferred
                        = reader.getNullable(JsonReader::getLong);
                } else if ("ingressBytesTransferred".equals(fieldName)) {
                    deserializedVpnClientConnectionHealthDetail.ingressBytesTransferred
                        = reader.getNullable(JsonReader::getLong);
                } else if ("maxPacketsPerSecond".equals(fieldName)) {
                    deserializedVpnClientConnectionHealthDetail.maxPacketsPerSecond
                        = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnClientConnectionHealthDetail;
        });
    }
}
