// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the filter values possibles for a given column.
 */
@Fluent
public final class SignatureOverridesFilterValuesQuery
    implements JsonSerializable<SignatureOverridesFilterValuesQuery> {
    /*
     * Describes the name of the column which values will be returned
     */
    private String filterName;

    /**
     * Creates an instance of SignatureOverridesFilterValuesQuery class.
     */
    public SignatureOverridesFilterValuesQuery() {
    }

    /**
     * Get the filterName property: Describes the name of the column which values will be returned.
     * 
     * @return the filterName value.
     */
    public String filterName() {
        return this.filterName;
    }

    /**
     * Set the filterName property: Describes the name of the column which values will be returned.
     * 
     * @param filterName the filterName value to set.
     * @return the SignatureOverridesFilterValuesQuery object itself.
     */
    public SignatureOverridesFilterValuesQuery withFilterName(String filterName) {
        this.filterName = filterName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("filterName", this.filterName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SignatureOverridesFilterValuesQuery from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SignatureOverridesFilterValuesQuery if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SignatureOverridesFilterValuesQuery.
     */
    public static SignatureOverridesFilterValuesQuery fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SignatureOverridesFilterValuesQuery deserializedSignatureOverridesFilterValuesQuery
                = new SignatureOverridesFilterValuesQuery();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("filterName".equals(fieldName)) {
                    deserializedSignatureOverridesFilterValuesQuery.filterName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSignatureOverridesFilterValuesQuery;
        });
    }
}
