// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The PerimeterBasedAccessRule model.
 */
@Immutable
public final class PerimeterBasedAccessRule implements JsonSerializable<PerimeterBasedAccessRule> {
    /*
     * NSP id in the ARM id format.
     */
    private String id;

    /*
     * Resource guid of the NSP supplied.
     */
    private String perimeterGuid;

    /*
     * Location of the NSP supplied.
     */
    private String location;

    /**
     * Creates an instance of PerimeterBasedAccessRule class.
     */
    public PerimeterBasedAccessRule() {
    }

    /**
     * Get the id property: NSP id in the ARM id format.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the perimeterGuid property: Resource guid of the NSP supplied.
     * 
     * @return the perimeterGuid value.
     */
    public String perimeterGuid() {
        return this.perimeterGuid;
    }

    /**
     * Get the location property: Location of the NSP supplied.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PerimeterBasedAccessRule from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PerimeterBasedAccessRule if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PerimeterBasedAccessRule.
     */
    public static PerimeterBasedAccessRule fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PerimeterBasedAccessRule deserializedPerimeterBasedAccessRule = new PerimeterBasedAccessRule();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPerimeterBasedAccessRule.id = reader.getString();
                } else if ("perimeterGuid".equals(fieldName)) {
                    deserializedPerimeterBasedAccessRule.perimeterGuid = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedPerimeterBasedAccessRule.location = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPerimeterBasedAccessRule;
        });
    }
}
