// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.PerimeterAssociableResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * Paged list of perimeter associable resources.
 */
@Fluent
public final class PerimeterAssociableResourcesListResult
    implements JsonSerializable<PerimeterAssociableResourcesListResult> {
    /*
     * Gets paged list of perimeter associable resources.
     */
    private List<PerimeterAssociableResourceInner> value;

    /*
     * Gets the URL to get the next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of PerimeterAssociableResourcesListResult class.
     */
    public PerimeterAssociableResourcesListResult() {
    }

    /**
     * Get the value property: Gets paged list of perimeter associable resources.
     * 
     * @return the value value.
     */
    public List<PerimeterAssociableResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Gets paged list of perimeter associable resources.
     * 
     * @param value the value value to set.
     * @return the PerimeterAssociableResourcesListResult object itself.
     */
    public PerimeterAssociableResourcesListResult withValue(List<PerimeterAssociableResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Gets the URL to get the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Gets the URL to get the next page of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the PerimeterAssociableResourcesListResult object itself.
     */
    public PerimeterAssociableResourcesListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PerimeterAssociableResourcesListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PerimeterAssociableResourcesListResult if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PerimeterAssociableResourcesListResult.
     */
    public static PerimeterAssociableResourcesListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PerimeterAssociableResourcesListResult deserializedPerimeterAssociableResourcesListResult
                = new PerimeterAssociableResourcesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<PerimeterAssociableResourceInner> value
                        = reader.readArray(reader1 -> PerimeterAssociableResourceInner.fromJson(reader1));
                    deserializedPerimeterAssociableResourcesListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedPerimeterAssociableResourcesListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPerimeterAssociableResourcesListResult;
        });
    }
}
