// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The NSP link state.
 */
public final class NspLinkStatus extends ExpandableStringEnum<NspLinkStatus> {
    /**
     * Static value Approved for NspLinkStatus.
     */
    public static final NspLinkStatus APPROVED = fromString("Approved");

    /**
     * Static value Pending for NspLinkStatus.
     */
    public static final NspLinkStatus PENDING = fromString("Pending");

    /**
     * Static value Rejected for NspLinkStatus.
     */
    public static final NspLinkStatus REJECTED = fromString("Rejected");

    /**
     * Static value Disconnected for NspLinkStatus.
     */
    public static final NspLinkStatus DISCONNECTED = fromString("Disconnected");

    /**
     * Creates a new instance of NspLinkStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public NspLinkStatus() {
    }

    /**
     * Creates or finds a NspLinkStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding NspLinkStatus.
     */
    public static NspLinkStatus fromString(String name) {
        return fromString(name, NspLinkStatus.class);
    }

    /**
     * Gets known NspLinkStatus values.
     * 
     * @return known NspLinkStatus values.
     */
    public static Collection<NspLinkStatus> values() {
        return values(NspLinkStatus.class);
    }
}
