// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The current provisioning state of NSP Link/LinkReference.
 */
public final class NspLinkProvisioningState extends ExpandableStringEnum<NspLinkProvisioningState> {
    /**
     * Static value Succeeded for NspLinkProvisioningState.
     */
    public static final NspLinkProvisioningState SUCCEEDED = fromString("Succeeded");

    /**
     * Static value Creating for NspLinkProvisioningState.
     */
    public static final NspLinkProvisioningState CREATING = fromString("Creating");

    /**
     * Static value Updating for NspLinkProvisioningState.
     */
    public static final NspLinkProvisioningState UPDATING = fromString("Updating");

    /**
     * Static value Deleting for NspLinkProvisioningState.
     */
    public static final NspLinkProvisioningState DELETING = fromString("Deleting");

    /**
     * Static value Accepted for NspLinkProvisioningState.
     */
    public static final NspLinkProvisioningState ACCEPTED = fromString("Accepted");

    /**
     * Static value Failed for NspLinkProvisioningState.
     */
    public static final NspLinkProvisioningState FAILED = fromString("Failed");

    /**
     * Static value WaitForRemoteCompletion for NspLinkProvisioningState.
     */
    public static final NspLinkProvisioningState WAIT_FOR_REMOTE_COMPLETION = fromString("WaitForRemoteCompletion");

    /**
     * Creates a new instance of NspLinkProvisioningState value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public NspLinkProvisioningState() {
    }

    /**
     * Creates or finds a NspLinkProvisioningState from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding NspLinkProvisioningState.
     */
    public static NspLinkProvisioningState fromString(String name) {
        return fromString(name, NspLinkProvisioningState.class);
    }

    /**
     * Gets known NspLinkProvisioningState values.
     * 
     * @return known NspLinkProvisioningState values.
     */
    public static Collection<NspLinkProvisioningState> values() {
        return values(NspLinkProvisioningState.class);
    }
}
