// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Defines a managed rule set rule group.
 */
@Fluent
public final class ManagedRuleSetRuleGroup implements JsonSerializable<ManagedRuleSetRuleGroup> {
    /*
     * Name of the rule group
     */
    private String ruleGroupName;

    /*
     * List of rules within the rule group
     */
    private List<String> rules;

    /**
     * Creates an instance of ManagedRuleSetRuleGroup class.
     */
    public ManagedRuleSetRuleGroup() {
    }

    /**
     * Get the ruleGroupName property: Name of the rule group.
     * 
     * @return the ruleGroupName value.
     */
    public String ruleGroupName() {
        return this.ruleGroupName;
    }

    /**
     * Set the ruleGroupName property: Name of the rule group.
     * 
     * @param ruleGroupName the ruleGroupName value to set.
     * @return the ManagedRuleSetRuleGroup object itself.
     */
    public ManagedRuleSetRuleGroup withRuleGroupName(String ruleGroupName) {
        this.ruleGroupName = ruleGroupName;
        return this;
    }

    /**
     * Get the rules property: List of rules within the rule group.
     * 
     * @return the rules value.
     */
    public List<String> rules() {
        return this.rules;
    }

    /**
     * Set the rules property: List of rules within the rule group.
     * 
     * @param rules the rules value to set.
     * @return the ManagedRuleSetRuleGroup object itself.
     */
    public ManagedRuleSetRuleGroup withRules(List<String> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ruleGroupName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property ruleGroupName in model ManagedRuleSetRuleGroup"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ManagedRuleSetRuleGroup.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ruleGroupName", this.ruleGroupName);
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ManagedRuleSetRuleGroup from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ManagedRuleSetRuleGroup if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ManagedRuleSetRuleGroup.
     */
    public static ManagedRuleSetRuleGroup fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ManagedRuleSetRuleGroup deserializedManagedRuleSetRuleGroup = new ManagedRuleSetRuleGroup();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ruleGroupName".equals(fieldName)) {
                    deserializedManagedRuleSetRuleGroup.ruleGroupName = reader.getString();
                } else if ("rules".equals(fieldName)) {
                    List<String> rules = reader.readArray(reader1 -> reader1.getString());
                    deserializedManagedRuleSetRuleGroup.rules = rules;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedManagedRuleSetRuleGroup;
        });
    }
}
