// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The CircuitMetadataMap model.
 */
@Fluent
public final class CircuitMetadataMap implements JsonSerializable<CircuitMetadataMap> {
    /*
     * Express Route Circuit Name
     */
    private String name;

    /*
     * Link to the Express Route circuit
     */
    private String link;

    /*
     * Peering location of the Express Route Circuit
     */
    private String location;

    /**
     * Creates an instance of CircuitMetadataMap class.
     */
    public CircuitMetadataMap() {
    }

    /**
     * Get the name property: Express Route Circuit Name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Express Route Circuit Name.
     * 
     * @param name the name value to set.
     * @return the CircuitMetadataMap object itself.
     */
    public CircuitMetadataMap withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the link property: Link to the Express Route circuit.
     * 
     * @return the link value.
     */
    public String link() {
        return this.link;
    }

    /**
     * Set the link property: Link to the Express Route circuit.
     * 
     * @param link the link value to set.
     * @return the CircuitMetadataMap object itself.
     */
    public CircuitMetadataMap withLink(String link) {
        this.link = link;
        return this;
    }

    /**
     * Get the location property: Peering location of the Express Route Circuit.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Set the location property: Peering location of the Express Route Circuit.
     * 
     * @param location the location value to set.
     * @return the CircuitMetadataMap object itself.
     */
    public CircuitMetadataMap withLocation(String location) {
        this.location = location;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("link", this.link);
        jsonWriter.writeStringField("location", this.location);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CircuitMetadataMap from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CircuitMetadataMap if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CircuitMetadataMap.
     */
    public static CircuitMetadataMap fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CircuitMetadataMap deserializedCircuitMetadataMap = new CircuitMetadataMap();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedCircuitMetadataMap.name = reader.getString();
                } else if ("link".equals(fieldName)) {
                    deserializedCircuitMetadataMap.link = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedCircuitMetadataMap.location = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCircuitMetadataMap;
        });
    }
}
