// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * VpnServerConfigurations list associated with VirtualWan Response.
 */
@Fluent
public final class VpnServerConfigurationsResponseInner
    implements JsonSerializable<VpnServerConfigurationsResponseInner> {
    /*
     * List of VpnServerConfigurations associated with VirtualWan.
     */
    private List<String> vpnServerConfigurationResourceIds;

    /**
     * Creates an instance of VpnServerConfigurationsResponseInner class.
     */
    public VpnServerConfigurationsResponseInner() {
    }

    /**
     * Get the vpnServerConfigurationResourceIds property: List of VpnServerConfigurations associated with VirtualWan.
     * 
     * @return the vpnServerConfigurationResourceIds value.
     */
    public List<String> vpnServerConfigurationResourceIds() {
        return this.vpnServerConfigurationResourceIds;
    }

    /**
     * Set the vpnServerConfigurationResourceIds property: List of VpnServerConfigurations associated with VirtualWan.
     * 
     * @param vpnServerConfigurationResourceIds the vpnServerConfigurationResourceIds value to set.
     * @return the VpnServerConfigurationsResponseInner object itself.
     */
    public VpnServerConfigurationsResponseInner
        withVpnServerConfigurationResourceIds(List<String> vpnServerConfigurationResourceIds) {
        this.vpnServerConfigurationResourceIds = vpnServerConfigurationResourceIds;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("vpnServerConfigurationResourceIds", this.vpnServerConfigurationResourceIds,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VpnServerConfigurationsResponseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VpnServerConfigurationsResponseInner if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VpnServerConfigurationsResponseInner.
     */
    public static VpnServerConfigurationsResponseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VpnServerConfigurationsResponseInner deserializedVpnServerConfigurationsResponseInner
                = new VpnServerConfigurationsResponseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vpnServerConfigurationResourceIds".equals(fieldName)) {
                    List<String> vpnServerConfigurationResourceIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedVpnServerConfigurationsResponseInner.vpnServerConfigurationResourceIds
                        = vpnServerConfigurationResourceIds;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVpnServerConfigurationsResponseInner;
        });
    }
}
