// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

/**
 * Virtual Router Peering resource.
 */
@Fluent
public final class VirtualRouterPeeringInner extends SubResource {
    /*
     * The properties of the Virtual Router Peering.
     */
    private VirtualRouterPeeringProperties innerProperties;

    /*
     * Name of the virtual router peering that is unique within a virtual router.
     */
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    private String etag;

    /*
     * Peering type.
     */
    private String type;

    /**
     * Creates an instance of VirtualRouterPeeringInner class.
     */
    public VirtualRouterPeeringInner() {
    }

    /**
     * Get the innerProperties property: The properties of the Virtual Router Peering.
     * 
     * @return the innerProperties value.
     */
    private VirtualRouterPeeringProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Name of the virtual router peering that is unique within a virtual router.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the virtual router peering that is unique within a virtual router.
     * 
     * @param name the name value to set.
     * @return the VirtualRouterPeeringInner object itself.
     */
    public VirtualRouterPeeringInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Peering type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public VirtualRouterPeeringInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the peerAsn property: Peer ASN.
     * 
     * @return the peerAsn value.
     */
    public Long peerAsn() {
        return this.innerProperties() == null ? null : this.innerProperties().peerAsn();
    }

    /**
     * Set the peerAsn property: Peer ASN.
     * 
     * @param peerAsn the peerAsn value to set.
     * @return the VirtualRouterPeeringInner object itself.
     */
    public VirtualRouterPeeringInner withPeerAsn(Long peerAsn) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualRouterPeeringProperties();
        }
        this.innerProperties().withPeerAsn(peerAsn);
        return this;
    }

    /**
     * Get the peerIp property: Peer IP.
     * 
     * @return the peerIp value.
     */
    public String peerIp() {
        return this.innerProperties() == null ? null : this.innerProperties().peerIp();
    }

    /**
     * Set the peerIp property: Peer IP.
     * 
     * @param peerIp the peerIp value to set.
     * @return the VirtualRouterPeeringInner object itself.
     */
    public VirtualRouterPeeringInner withPeerIp(String peerIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualRouterPeeringProperties();
        }
        this.innerProperties().withPeerIp(peerIp);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", id());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualRouterPeeringInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualRouterPeeringInner if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualRouterPeeringInner.
     */
    public static VirtualRouterPeeringInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualRouterPeeringInner deserializedVirtualRouterPeeringInner = new VirtualRouterPeeringInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedVirtualRouterPeeringInner.withId(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedVirtualRouterPeeringInner.innerProperties
                        = VirtualRouterPeeringProperties.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedVirtualRouterPeeringInner.name = reader.getString();
                } else if ("etag".equals(fieldName)) {
                    deserializedVirtualRouterPeeringInner.etag = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedVirtualRouterPeeringInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualRouterPeeringInner;
        });
    }
}
