// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VirtualHubRouteV2;
import java.io.IOException;
import java.util.List;

/**
 * Parameters for VirtualHubRouteTableV2.
 */
@Fluent
public final class VirtualHubRouteTableV2Properties implements JsonSerializable<VirtualHubRouteTableV2Properties> {
    /*
     * List of all routes.
     */
    private List<VirtualHubRouteV2> routes;

    /*
     * List of all connections attached to this route table v2.
     */
    private List<String> attachedConnections;

    /*
     * The provisioning state of the virtual hub route table v2 resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of VirtualHubRouteTableV2Properties class.
     */
    public VirtualHubRouteTableV2Properties() {
    }

    /**
     * Get the routes property: List of all routes.
     * 
     * @return the routes value.
     */
    public List<VirtualHubRouteV2> routes() {
        return this.routes;
    }

    /**
     * Set the routes property: List of all routes.
     * 
     * @param routes the routes value to set.
     * @return the VirtualHubRouteTableV2Properties object itself.
     */
    public VirtualHubRouteTableV2Properties withRoutes(List<VirtualHubRouteV2> routes) {
        this.routes = routes;
        return this;
    }

    /**
     * Get the attachedConnections property: List of all connections attached to this route table v2.
     * 
     * @return the attachedConnections value.
     */
    public List<String> attachedConnections() {
        return this.attachedConnections;
    }

    /**
     * Set the attachedConnections property: List of all connections attached to this route table v2.
     * 
     * @param attachedConnections the attachedConnections value to set.
     * @return the VirtualHubRouteTableV2Properties object itself.
     */
    public VirtualHubRouteTableV2Properties withAttachedConnections(List<String> attachedConnections) {
        this.attachedConnections = attachedConnections;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the virtual hub route table v2 resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (routes() != null) {
            routes().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("routes", this.routes, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("attachedConnections", this.attachedConnections,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualHubRouteTableV2Properties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualHubRouteTableV2Properties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualHubRouteTableV2Properties.
     */
    public static VirtualHubRouteTableV2Properties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualHubRouteTableV2Properties deserializedVirtualHubRouteTableV2Properties
                = new VirtualHubRouteTableV2Properties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("routes".equals(fieldName)) {
                    List<VirtualHubRouteV2> routes = reader.readArray(reader1 -> VirtualHubRouteV2.fromJson(reader1));
                    deserializedVirtualHubRouteTableV2Properties.routes = routes;
                } else if ("attachedConnections".equals(fieldName)) {
                    List<String> attachedConnections = reader.readArray(reader1 -> reader1.getString());
                    deserializedVirtualHubRouteTableV2Properties.attachedConnections = attachedConnections;
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedVirtualHubRouteTableV2Properties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualHubRouteTableV2Properties;
        });
    }
}
