// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.CommonProxyResource;
import com.azure.resourcemanager.network.models.StaticCidrProperties;
import java.io.IOException;

/**
 * Instance of StaticCidr resource.
 */
@Fluent
public final class StaticCidrInner extends CommonProxyResource {
    /*
     * Properties of static CIDR resource.
     */
    private StaticCidrProperties properties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of StaticCidrInner class.
     */
    public StaticCidrInner() {
    }

    /**
     * Get the properties property: Properties of static CIDR resource.
     * 
     * @return the properties value.
     */
    public StaticCidrProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Properties of static CIDR resource.
     * 
     * @param properties the properties value to set.
     * @return the StaticCidrInner object itself.
     */
    public StaticCidrInner withProperties(StaticCidrProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.properties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticCidrInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticCidrInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StaticCidrInner.
     */
    public static StaticCidrInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StaticCidrInner deserializedStaticCidrInner = new StaticCidrInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedStaticCidrInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedStaticCidrInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedStaticCidrInner.type = reader.getString();
                } else if ("systemData".equals(fieldName)) {
                    deserializedStaticCidrInner.systemData = SystemData.fromJson(reader);
                } else if ("properties".equals(fieldName)) {
                    deserializedStaticCidrInner.properties = StaticCidrProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticCidrInner;
        });
    }
}
