// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Response for the CheckPrivateLinkServiceVisibility API service call.
 */
@Fluent
public final class PrivateLinkServiceVisibilityInner implements JsonSerializable<PrivateLinkServiceVisibilityInner> {
    /*
     * Private Link Service Visibility (True/False).
     */
    private Boolean visible;

    /**
     * Creates an instance of PrivateLinkServiceVisibilityInner class.
     */
    public PrivateLinkServiceVisibilityInner() {
    }

    /**
     * Get the visible property: Private Link Service Visibility (True/False).
     * 
     * @return the visible value.
     */
    public Boolean visible() {
        return this.visible;
    }

    /**
     * Set the visible property: Private Link Service Visibility (True/False).
     * 
     * @param visible the visible value to set.
     * @return the PrivateLinkServiceVisibilityInner object itself.
     */
    public PrivateLinkServiceVisibilityInner withVisible(Boolean visible) {
        this.visible = visible;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("visible", this.visible);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateLinkServiceVisibilityInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateLinkServiceVisibilityInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PrivateLinkServiceVisibilityInner.
     */
    public static PrivateLinkServiceVisibilityInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateLinkServiceVisibilityInner deserializedPrivateLinkServiceVisibilityInner
                = new PrivateLinkServiceVisibilityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("visible".equals(fieldName)) {
                    deserializedPrivateLinkServiceVisibilityInner.visible = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateLinkServiceVisibilityInner;
        });
    }
}
