// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.ProtocolType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.QosDefinition;
import com.azure.resourcemanager.network.models.QosIpRange;
import com.azure.resourcemanager.network.models.QosPortRange;
import java.io.IOException;
import java.util.List;

/**
 * Differentiated Services Code Point configuration properties.
 */
@Fluent
public final class DscpConfigurationPropertiesFormat implements JsonSerializable<DscpConfigurationPropertiesFormat> {
    /*
     * List of markings to be used in the configuration.
     */
    private List<Integer> markings;

    /*
     * Source IP ranges.
     */
    private List<QosIpRange> sourceIpRanges;

    /*
     * Destination IP ranges.
     */
    private List<QosIpRange> destinationIpRanges;

    /*
     * Sources port ranges.
     */
    private List<QosPortRange> sourcePortRanges;

    /*
     * Destination port ranges.
     */
    private List<QosPortRange> destinationPortRanges;

    /*
     * RNM supported protocol types.
     */
    private ProtocolType protocol;

    /*
     * QoS object definitions
     */
    private List<QosDefinition> qosDefinitionCollection;

    /*
     * Qos Collection ID generated by RNM.
     */
    private String qosCollectionId;

    /*
     * Associated Network Interfaces to the DSCP Configuration.
     */
    private List<NetworkInterfaceInner> associatedNetworkInterfaces;

    /*
     * The resource GUID property of the DSCP Configuration resource.
     */
    private String resourceGuid;

    /*
     * The provisioning state of the DSCP Configuration resource.
     */
    private ProvisioningState provisioningState;

    /**
     * Creates an instance of DscpConfigurationPropertiesFormat class.
     */
    public DscpConfigurationPropertiesFormat() {
    }

    /**
     * Get the markings property: List of markings to be used in the configuration.
     * 
     * @return the markings value.
     */
    public List<Integer> markings() {
        return this.markings;
    }

    /**
     * Set the markings property: List of markings to be used in the configuration.
     * 
     * @param markings the markings value to set.
     * @return the DscpConfigurationPropertiesFormat object itself.
     */
    public DscpConfigurationPropertiesFormat withMarkings(List<Integer> markings) {
        this.markings = markings;
        return this;
    }

    /**
     * Get the sourceIpRanges property: Source IP ranges.
     * 
     * @return the sourceIpRanges value.
     */
    public List<QosIpRange> sourceIpRanges() {
        return this.sourceIpRanges;
    }

    /**
     * Set the sourceIpRanges property: Source IP ranges.
     * 
     * @param sourceIpRanges the sourceIpRanges value to set.
     * @return the DscpConfigurationPropertiesFormat object itself.
     */
    public DscpConfigurationPropertiesFormat withSourceIpRanges(List<QosIpRange> sourceIpRanges) {
        this.sourceIpRanges = sourceIpRanges;
        return this;
    }

    /**
     * Get the destinationIpRanges property: Destination IP ranges.
     * 
     * @return the destinationIpRanges value.
     */
    public List<QosIpRange> destinationIpRanges() {
        return this.destinationIpRanges;
    }

    /**
     * Set the destinationIpRanges property: Destination IP ranges.
     * 
     * @param destinationIpRanges the destinationIpRanges value to set.
     * @return the DscpConfigurationPropertiesFormat object itself.
     */
    public DscpConfigurationPropertiesFormat withDestinationIpRanges(List<QosIpRange> destinationIpRanges) {
        this.destinationIpRanges = destinationIpRanges;
        return this;
    }

    /**
     * Get the sourcePortRanges property: Sources port ranges.
     * 
     * @return the sourcePortRanges value.
     */
    public List<QosPortRange> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    /**
     * Set the sourcePortRanges property: Sources port ranges.
     * 
     * @param sourcePortRanges the sourcePortRanges value to set.
     * @return the DscpConfigurationPropertiesFormat object itself.
     */
    public DscpConfigurationPropertiesFormat withSourcePortRanges(List<QosPortRange> sourcePortRanges) {
        this.sourcePortRanges = sourcePortRanges;
        return this;
    }

    /**
     * Get the destinationPortRanges property: Destination port ranges.
     * 
     * @return the destinationPortRanges value.
     */
    public List<QosPortRange> destinationPortRanges() {
        return this.destinationPortRanges;
    }

    /**
     * Set the destinationPortRanges property: Destination port ranges.
     * 
     * @param destinationPortRanges the destinationPortRanges value to set.
     * @return the DscpConfigurationPropertiesFormat object itself.
     */
    public DscpConfigurationPropertiesFormat withDestinationPortRanges(List<QosPortRange> destinationPortRanges) {
        this.destinationPortRanges = destinationPortRanges;
        return this;
    }

    /**
     * Get the protocol property: RNM supported protocol types.
     * 
     * @return the protocol value.
     */
    public ProtocolType protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: RNM supported protocol types.
     * 
     * @param protocol the protocol value to set.
     * @return the DscpConfigurationPropertiesFormat object itself.
     */
    public DscpConfigurationPropertiesFormat withProtocol(ProtocolType protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Get the qosDefinitionCollection property: QoS object definitions.
     * 
     * @return the qosDefinitionCollection value.
     */
    public List<QosDefinition> qosDefinitionCollection() {
        return this.qosDefinitionCollection;
    }

    /**
     * Set the qosDefinitionCollection property: QoS object definitions.
     * 
     * @param qosDefinitionCollection the qosDefinitionCollection value to set.
     * @return the DscpConfigurationPropertiesFormat object itself.
     */
    public DscpConfigurationPropertiesFormat withQosDefinitionCollection(List<QosDefinition> qosDefinitionCollection) {
        this.qosDefinitionCollection = qosDefinitionCollection;
        return this;
    }

    /**
     * Get the qosCollectionId property: Qos Collection ID generated by RNM.
     * 
     * @return the qosCollectionId value.
     */
    public String qosCollectionId() {
        return this.qosCollectionId;
    }

    /**
     * Get the associatedNetworkInterfaces property: Associated Network Interfaces to the DSCP Configuration.
     * 
     * @return the associatedNetworkInterfaces value.
     */
    public List<NetworkInterfaceInner> associatedNetworkInterfaces() {
        return this.associatedNetworkInterfaces;
    }

    /**
     * Get the resourceGuid property: The resource GUID property of the DSCP Configuration resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.resourceGuid;
    }

    /**
     * Get the provisioningState property: The provisioning state of the DSCP Configuration resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceIpRanges() != null) {
            sourceIpRanges().forEach(e -> e.validate());
        }
        if (destinationIpRanges() != null) {
            destinationIpRanges().forEach(e -> e.validate());
        }
        if (sourcePortRanges() != null) {
            sourcePortRanges().forEach(e -> e.validate());
        }
        if (destinationPortRanges() != null) {
            destinationPortRanges().forEach(e -> e.validate());
        }
        if (qosDefinitionCollection() != null) {
            qosDefinitionCollection().forEach(e -> e.validate());
        }
        if (associatedNetworkInterfaces() != null) {
            associatedNetworkInterfaces().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("markings", this.markings, (writer, element) -> writer.writeInt(element));
        jsonWriter.writeArrayField("sourceIpRanges", this.sourceIpRanges,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("destinationIpRanges", this.destinationIpRanges,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("sourcePortRanges", this.sourcePortRanges,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("destinationPortRanges", this.destinationPortRanges,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        jsonWriter.writeArrayField("qosDefinitionCollection", this.qosDefinitionCollection,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DscpConfigurationPropertiesFormat from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DscpConfigurationPropertiesFormat if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DscpConfigurationPropertiesFormat.
     */
    public static DscpConfigurationPropertiesFormat fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DscpConfigurationPropertiesFormat deserializedDscpConfigurationPropertiesFormat
                = new DscpConfigurationPropertiesFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("markings".equals(fieldName)) {
                    List<Integer> markings = reader.readArray(reader1 -> reader1.getInt());
                    deserializedDscpConfigurationPropertiesFormat.markings = markings;
                } else if ("sourceIpRanges".equals(fieldName)) {
                    List<QosIpRange> sourceIpRanges = reader.readArray(reader1 -> QosIpRange.fromJson(reader1));
                    deserializedDscpConfigurationPropertiesFormat.sourceIpRanges = sourceIpRanges;
                } else if ("destinationIpRanges".equals(fieldName)) {
                    List<QosIpRange> destinationIpRanges = reader.readArray(reader1 -> QosIpRange.fromJson(reader1));
                    deserializedDscpConfigurationPropertiesFormat.destinationIpRanges = destinationIpRanges;
                } else if ("sourcePortRanges".equals(fieldName)) {
                    List<QosPortRange> sourcePortRanges = reader.readArray(reader1 -> QosPortRange.fromJson(reader1));
                    deserializedDscpConfigurationPropertiesFormat.sourcePortRanges = sourcePortRanges;
                } else if ("destinationPortRanges".equals(fieldName)) {
                    List<QosPortRange> destinationPortRanges
                        = reader.readArray(reader1 -> QosPortRange.fromJson(reader1));
                    deserializedDscpConfigurationPropertiesFormat.destinationPortRanges = destinationPortRanges;
                } else if ("protocol".equals(fieldName)) {
                    deserializedDscpConfigurationPropertiesFormat.protocol
                        = ProtocolType.fromString(reader.getString());
                } else if ("qosDefinitionCollection".equals(fieldName)) {
                    List<QosDefinition> qosDefinitionCollection
                        = reader.readArray(reader1 -> QosDefinition.fromJson(reader1));
                    deserializedDscpConfigurationPropertiesFormat.qosDefinitionCollection = qosDefinitionCollection;
                } else if ("qosCollectionId".equals(fieldName)) {
                    deserializedDscpConfigurationPropertiesFormat.qosCollectionId = reader.getString();
                } else if ("associatedNetworkInterfaces".equals(fieldName)) {
                    List<NetworkInterfaceInner> associatedNetworkInterfaces
                        = reader.readArray(reader1 -> NetworkInterfaceInner.fromJson(reader1));
                    deserializedDscpConfigurationPropertiesFormat.associatedNetworkInterfaces
                        = associatedNetworkInterfaces;
                } else if ("resourceGuid".equals(fieldName)) {
                    deserializedDscpConfigurationPropertiesFormat.resourceGuid = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedDscpConfigurationPropertiesFormat.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDscpConfigurationPropertiesFormat;
        });
    }
}
