// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.models.NspAssociationInner;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in
 * NetworkSecurityPerimeterAssociationsClient.
 */
public interface NetworkSecurityPerimeterAssociationsClient {
    /**
     * Gets the specified NSP association by name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified NSP association by name along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NspAssociationInner>> getWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String associationName);

    /**
     * Gets the specified NSP association by name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified NSP association by name on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NspAssociationInner> getAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String associationName);

    /**
     * Gets the specified NSP association by name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified NSP association by name along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NspAssociationInner> getWithResponse(String resourceGroupName, String networkSecurityPerimeterName,
        String associationName, Context context);

    /**
     * Gets the specified NSP association by name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified NSP association by name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NspAssociationInner get(String resourceGroupName, String networkSecurityPerimeterName, String associationName);

    /**
     * Creates or updates a NSP resource association.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @param parameters Parameters that hold the NspAssociation resource to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP resource association resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String associationName, NspAssociationInner parameters);

    /**
     * Creates or updates a NSP resource association.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @param parameters Parameters that hold the NspAssociation resource to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the NSP resource association resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<NspAssociationInner>, NspAssociationInner> beginCreateOrUpdateAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String associationName, NspAssociationInner parameters);

    /**
     * Creates or updates a NSP resource association.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @param parameters Parameters that hold the NspAssociation resource to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the NSP resource association resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<NspAssociationInner>, NspAssociationInner> beginCreateOrUpdate(String resourceGroupName,
        String networkSecurityPerimeterName, String associationName, NspAssociationInner parameters);

    /**
     * Creates or updates a NSP resource association.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @param parameters Parameters that hold the NspAssociation resource to be created/updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the NSP resource association resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<NspAssociationInner>, NspAssociationInner> beginCreateOrUpdate(String resourceGroupName,
        String networkSecurityPerimeterName, String associationName, NspAssociationInner parameters, Context context);

    /**
     * Creates or updates a NSP resource association.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @param parameters Parameters that hold the NspAssociation resource to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP resource association resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NspAssociationInner> createOrUpdateAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String associationName, NspAssociationInner parameters);

    /**
     * Creates or updates a NSP resource association.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @param parameters Parameters that hold the NspAssociation resource to be created/updated.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP resource association resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NspAssociationInner createOrUpdate(String resourceGroupName, String networkSecurityPerimeterName,
        String associationName, NspAssociationInner parameters);

    /**
     * Creates or updates a NSP resource association.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @param parameters Parameters that hold the NspAssociation resource to be created/updated.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the NSP resource association resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NspAssociationInner createOrUpdate(String resourceGroupName, String networkSecurityPerimeterName,
        String associationName, NspAssociationInner parameters, Context context);

    /**
     * Deletes an NSP association resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName, String associationName);

    /**
     * Deletes an NSP association resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String associationName);

    /**
     * Deletes an NSP association resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkSecurityPerimeterName,
        String associationName);

    /**
     * Deletes an NSP association resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkSecurityPerimeterName,
        String associationName, Context context);

    /**
     * Deletes an NSP association resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String networkSecurityPerimeterName, String associationName);

    /**
     * Deletes an NSP association resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String networkSecurityPerimeterName, String associationName);

    /**
     * Deletes an NSP association resource.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String networkSecurityPerimeterName, String associationName, Context context);

    /**
     * Lists the NSP resource associations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param top An optional query parameter which specifies the maximum number of records to be returned by the
     * server.
     * @param skipToken SkipToken is only used if a previous operation returned a partial result. If a previous response
     * contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies
     * a starting point to use for subsequent calls.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP resource associations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NspAssociationInner> listAsync(String resourceGroupName, String networkSecurityPerimeterName, Integer top,
        String skipToken);

    /**
     * Lists the NSP resource associations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP resource associations as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NspAssociationInner> listAsync(String resourceGroupName, String networkSecurityPerimeterName);

    /**
     * Lists the NSP resource associations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP resource associations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NspAssociationInner> list(String resourceGroupName, String networkSecurityPerimeterName);

    /**
     * Lists the NSP resource associations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param top An optional query parameter which specifies the maximum number of records to be returned by the
     * server.
     * @param skipToken SkipToken is only used if a previous operation returned a partial result. If a previous response
     * contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies
     * a starting point to use for subsequent calls.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NSP resource associations as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NspAssociationInner> list(String resourceGroupName, String networkSecurityPerimeterName, Integer top,
        String skipToken, Context context);

    /**
     * Reconcile NSP association.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @param parameters Parameters for NSP association reconcile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Object>> reconcileWithResponseAsync(String resourceGroupName, String networkSecurityPerimeterName,
        String associationName, Object parameters);

    /**
     * Reconcile NSP association.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @param parameters Parameters for NSP association reconcile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Object> reconcileAsync(String resourceGroupName, String networkSecurityPerimeterName, String associationName,
        Object parameters);

    /**
     * Reconcile NSP association.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @param parameters Parameters for NSP association reconcile.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<Object> reconcileWithResponse(String resourceGroupName, String networkSecurityPerimeterName,
        String associationName, Object parameters, Context context);

    /**
     * Reconcile NSP association.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param associationName The name of the NSP association.
     * @param parameters Parameters for NSP association reconcile.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return any object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Object reconcile(String resourceGroupName, String networkSecurityPerimeterName, String associationName,
        Object parameters);
}
