/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AssociationAccessMode;
import com.azure.resourcemanager.network.models.NspProvisioningState;
import java.io.IOException;

public final class NspAssociationProperties
implements JsonSerializable<NspAssociationProperties> {
    private NspProvisioningState provisioningState;
    private SubResource privateLinkResource;
    private SubResource profile;
    private AssociationAccessMode accessMode;
    private String hasProvisioningIssues;

    public NspProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public SubResource privateLinkResource() {
        return this.privateLinkResource;
    }

    public NspAssociationProperties withPrivateLinkResource(SubResource privateLinkResource) {
        this.privateLinkResource = privateLinkResource;
        return this;
    }

    public SubResource profile() {
        return this.profile;
    }

    public NspAssociationProperties withProfile(SubResource profile) {
        this.profile = profile;
        return this;
    }

    public AssociationAccessMode accessMode() {
        return this.accessMode;
    }

    public NspAssociationProperties withAccessMode(AssociationAccessMode accessMode) {
        this.accessMode = accessMode;
        return this;
    }

    public String hasProvisioningIssues() {
        return this.hasProvisioningIssues;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("privateLinkResource", (JsonSerializable)this.privateLinkResource);
        jsonWriter.writeJsonField("profile", (JsonSerializable)this.profile);
        jsonWriter.writeStringField("accessMode", this.accessMode == null ? null : this.accessMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static NspAssociationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (NspAssociationProperties)jsonReader.readObject(reader -> {
            NspAssociationProperties deserializedNspAssociationProperties = new NspAssociationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedNspAssociationProperties.provisioningState = NspProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("privateLinkResource".equals(fieldName)) {
                    deserializedNspAssociationProperties.privateLinkResource = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("profile".equals(fieldName)) {
                    deserializedNspAssociationProperties.profile = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("accessMode".equals(fieldName)) {
                    deserializedNspAssociationProperties.accessMode = AssociationAccessMode.fromString(reader.getString());
                    continue;
                }
                if ("hasProvisioningIssues".equals(fieldName)) {
                    deserializedNspAssociationProperties.hasProvisioningIssues = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNspAssociationProperties;
        });
    }
}

