/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.ProvisioningState;
import java.io.IOException;

public final class ApplicationGatewayPrivateLinkIpConfigurationProperties
implements JsonSerializable<ApplicationGatewayPrivateLinkIpConfigurationProperties> {
    private String privateIpAddress;
    private IpAllocationMethod privateIpAllocationMethod;
    private SubResource subnet;
    private Boolean primary;
    private ProvisioningState provisioningState;

    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    public ApplicationGatewayPrivateLinkIpConfigurationProperties withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    public ApplicationGatewayPrivateLinkIpConfigurationProperties withPrivateIpAllocationMethod(IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    public SubResource subnet() {
        return this.subnet;
    }

    public ApplicationGatewayPrivateLinkIpConfigurationProperties withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    public Boolean primary() {
        return this.primary;
    }

    public ApplicationGatewayPrivateLinkIpConfigurationProperties withPrimary(Boolean primary) {
        this.primary = primary;
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("privateIPAddress", this.privateIpAddress);
        jsonWriter.writeStringField("privateIPAllocationMethod", this.privateIpAllocationMethod == null ? null : this.privateIpAllocationMethod.toString());
        jsonWriter.writeJsonField("subnet", (JsonSerializable)this.subnet);
        jsonWriter.writeBooleanField("primary", this.primary);
        return jsonWriter.writeEndObject();
    }

    public static ApplicationGatewayPrivateLinkIpConfigurationProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ApplicationGatewayPrivateLinkIpConfigurationProperties)jsonReader.readObject(reader -> {
            ApplicationGatewayPrivateLinkIpConfigurationProperties deserializedApplicationGatewayPrivateLinkIpConfigurationProperties = new ApplicationGatewayPrivateLinkIpConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateIPAddress".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkIpConfigurationProperties.privateIpAddress = reader.getString();
                    continue;
                }
                if ("privateIPAllocationMethod".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkIpConfigurationProperties.privateIpAllocationMethod = IpAllocationMethod.fromString(reader.getString());
                    continue;
                }
                if ("subnet".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkIpConfigurationProperties.subnet = SubResource.fromJson((JsonReader)reader);
                    continue;
                }
                if ("primary".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkIpConfigurationProperties.primary = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedApplicationGatewayPrivateLinkIpConfigurationProperties.provisioningState = ProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApplicationGatewayPrivateLinkIpConfigurationProperties;
        });
    }
}

