// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for the ListVirtualNetworkGateways API service call.
 */
@Fluent
public final class VirtualNetworkGatewayListResult implements JsonSerializable<VirtualNetworkGatewayListResult> {
    /*
     * A list of VirtualNetworkGateway resources that exists in a resource group.
     */
    private List<VirtualNetworkGatewayInner> value;

    /*
     * The URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of VirtualNetworkGatewayListResult class.
     */
    public VirtualNetworkGatewayListResult() {
    }

    /**
     * Get the value property: A list of VirtualNetworkGateway resources that exists in a resource group.
     * 
     * @return the value value.
     */
    public List<VirtualNetworkGatewayInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of VirtualNetworkGateway resources that exists in a resource group.
     * 
     * @param value the value value to set.
     * @return the VirtualNetworkGatewayListResult object itself.
     */
    public VirtualNetworkGatewayListResult withValue(List<VirtualNetworkGatewayInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkGatewayListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkGatewayListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkGatewayListResult.
     */
    public static VirtualNetworkGatewayListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkGatewayListResult deserializedVirtualNetworkGatewayListResult
                = new VirtualNetworkGatewayListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<VirtualNetworkGatewayInner> value
                        = reader.readArray(reader1 -> VirtualNetworkGatewayInner.fromJson(reader1));
                    deserializedVirtualNetworkGatewayListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkGatewayListResult;
        });
    }
}
