// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The VirtualNetworkGatewayConnectionTunnelProperties model.
 */
@Fluent
public final class VirtualNetworkGatewayConnectionTunnelProperties
    implements JsonSerializable<VirtualNetworkGatewayConnectionTunnelProperties> {
    /*
     * Tunnel remote IP address
     */
    private String tunnelIpAddress;

    /*
     * Tunnel BGP peering address
     */
    private String bgpPeeringAddress;

    /**
     * Creates an instance of VirtualNetworkGatewayConnectionTunnelProperties class.
     */
    public VirtualNetworkGatewayConnectionTunnelProperties() {
    }

    /**
     * Get the tunnelIpAddress property: Tunnel remote IP address.
     * 
     * @return the tunnelIpAddress value.
     */
    public String tunnelIpAddress() {
        return this.tunnelIpAddress;
    }

    /**
     * Set the tunnelIpAddress property: Tunnel remote IP address.
     * 
     * @param tunnelIpAddress the tunnelIpAddress value to set.
     * @return the VirtualNetworkGatewayConnectionTunnelProperties object itself.
     */
    public VirtualNetworkGatewayConnectionTunnelProperties withTunnelIpAddress(String tunnelIpAddress) {
        this.tunnelIpAddress = tunnelIpAddress;
        return this;
    }

    /**
     * Get the bgpPeeringAddress property: Tunnel BGP peering address.
     * 
     * @return the bgpPeeringAddress value.
     */
    public String bgpPeeringAddress() {
        return this.bgpPeeringAddress;
    }

    /**
     * Set the bgpPeeringAddress property: Tunnel BGP peering address.
     * 
     * @param bgpPeeringAddress the bgpPeeringAddress value to set.
     * @return the VirtualNetworkGatewayConnectionTunnelProperties object itself.
     */
    public VirtualNetworkGatewayConnectionTunnelProperties withBgpPeeringAddress(String bgpPeeringAddress) {
        this.bgpPeeringAddress = bgpPeeringAddress;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("tunnelIpAddress", this.tunnelIpAddress);
        jsonWriter.writeStringField("bgpPeeringAddress", this.bgpPeeringAddress);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualNetworkGatewayConnectionTunnelProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualNetworkGatewayConnectionTunnelProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualNetworkGatewayConnectionTunnelProperties.
     */
    public static VirtualNetworkGatewayConnectionTunnelProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualNetworkGatewayConnectionTunnelProperties deserializedVirtualNetworkGatewayConnectionTunnelProperties
                = new VirtualNetworkGatewayConnectionTunnelProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("tunnelIpAddress".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionTunnelProperties.tunnelIpAddress = reader.getString();
                } else if ("bgpPeeringAddress".equals(fieldName)) {
                    deserializedVirtualNetworkGatewayConnectionTunnelProperties.bgpPeeringAddress = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualNetworkGatewayConnectionTunnelProperties;
        });
    }
}
