// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Metadata pertaining to creation and last modification of the resource.
 */
@Fluent
public final class SecurityPerimeterSystemData implements JsonSerializable<SecurityPerimeterSystemData> {
    /*
     * The identity that created the resource.
     */
    private String createdBy;

    /*
     * The type of identity that created the resource.
     */
    private CreatedByType createdByType;

    /*
     * The timestamp of resource creation (UTC).
     */
    private OffsetDateTime createdAt;

    /*
     * The identity that last modified the resource.
     */
    private String lastModifiedBy;

    /*
     * The type of identity that last modified the resource.
     */
    private CreatedByType lastModifiedByType;

    /*
     * The timestamp of resource last modification (UTC)
     */
    private OffsetDateTime lastModifiedAt;

    /**
     * Creates an instance of SecurityPerimeterSystemData class.
     */
    public SecurityPerimeterSystemData() {
    }

    /**
     * Get the createdBy property: The identity that created the resource.
     * 
     * @return the createdBy value.
     */
    public String createdBy() {
        return this.createdBy;
    }

    /**
     * Set the createdBy property: The identity that created the resource.
     * 
     * @param createdBy the createdBy value to set.
     * @return the SecurityPerimeterSystemData object itself.
     */
    public SecurityPerimeterSystemData withCreatedBy(String createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    /**
     * Get the createdByType property: The type of identity that created the resource.
     * 
     * @return the createdByType value.
     */
    public CreatedByType createdByType() {
        return this.createdByType;
    }

    /**
     * Set the createdByType property: The type of identity that created the resource.
     * 
     * @param createdByType the createdByType value to set.
     * @return the SecurityPerimeterSystemData object itself.
     */
    public SecurityPerimeterSystemData withCreatedByType(CreatedByType createdByType) {
        this.createdByType = createdByType;
        return this;
    }

    /**
     * Get the createdAt property: The timestamp of resource creation (UTC).
     * 
     * @return the createdAt value.
     */
    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    /**
     * Set the createdAt property: The timestamp of resource creation (UTC).
     * 
     * @param createdAt the createdAt value to set.
     * @return the SecurityPerimeterSystemData object itself.
     */
    public SecurityPerimeterSystemData withCreatedAt(OffsetDateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    /**
     * Get the lastModifiedBy property: The identity that last modified the resource.
     * 
     * @return the lastModifiedBy value.
     */
    public String lastModifiedBy() {
        return this.lastModifiedBy;
    }

    /**
     * Set the lastModifiedBy property: The identity that last modified the resource.
     * 
     * @param lastModifiedBy the lastModifiedBy value to set.
     * @return the SecurityPerimeterSystemData object itself.
     */
    public SecurityPerimeterSystemData withLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
        return this;
    }

    /**
     * Get the lastModifiedByType property: The type of identity that last modified the resource.
     * 
     * @return the lastModifiedByType value.
     */
    public CreatedByType lastModifiedByType() {
        return this.lastModifiedByType;
    }

    /**
     * Set the lastModifiedByType property: The type of identity that last modified the resource.
     * 
     * @param lastModifiedByType the lastModifiedByType value to set.
     * @return the SecurityPerimeterSystemData object itself.
     */
    public SecurityPerimeterSystemData withLastModifiedByType(CreatedByType lastModifiedByType) {
        this.lastModifiedByType = lastModifiedByType;
        return this;
    }

    /**
     * Get the lastModifiedAt property: The timestamp of resource last modification (UTC).
     * 
     * @return the lastModifiedAt value.
     */
    public OffsetDateTime lastModifiedAt() {
        return this.lastModifiedAt;
    }

    /**
     * Set the lastModifiedAt property: The timestamp of resource last modification (UTC).
     * 
     * @param lastModifiedAt the lastModifiedAt value to set.
     * @return the SecurityPerimeterSystemData object itself.
     */
    public SecurityPerimeterSystemData withLastModifiedAt(OffsetDateTime lastModifiedAt) {
        this.lastModifiedAt = lastModifiedAt;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createdBy", this.createdBy);
        jsonWriter.writeStringField("createdByType", this.createdByType == null ? null : this.createdByType.toString());
        jsonWriter.writeStringField("createdAt",
            this.createdAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.createdAt));
        jsonWriter.writeStringField("lastModifiedBy", this.lastModifiedBy);
        jsonWriter.writeStringField("lastModifiedByType",
            this.lastModifiedByType == null ? null : this.lastModifiedByType.toString());
        jsonWriter.writeStringField("lastModifiedAt",
            this.lastModifiedAt == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedAt));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SecurityPerimeterSystemData from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SecurityPerimeterSystemData if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SecurityPerimeterSystemData.
     */
    public static SecurityPerimeterSystemData fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SecurityPerimeterSystemData deserializedSecurityPerimeterSystemData = new SecurityPerimeterSystemData();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("createdBy".equals(fieldName)) {
                    deserializedSecurityPerimeterSystemData.createdBy = reader.getString();
                } else if ("createdByType".equals(fieldName)) {
                    deserializedSecurityPerimeterSystemData.createdByType
                        = CreatedByType.fromString(reader.getString());
                } else if ("createdAt".equals(fieldName)) {
                    deserializedSecurityPerimeterSystemData.createdAt = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastModifiedBy".equals(fieldName)) {
                    deserializedSecurityPerimeterSystemData.lastModifiedBy = reader.getString();
                } else if ("lastModifiedByType".equals(fieldName)) {
                    deserializedSecurityPerimeterSystemData.lastModifiedByType
                        = CreatedByType.fromString(reader.getString());
                } else if ("lastModifiedAt".equals(fieldName)) {
                    deserializedSecurityPerimeterSystemData.lastModifiedAt = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSecurityPerimeterSystemData;
        });
    }
}
