// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Represents the Reachability Analysis Intent properties.
 */
@Fluent
public final class ReachabilityAnalysisIntentProperties
    implements JsonSerializable<ReachabilityAnalysisIntentProperties> {
    /*
     * Provisioning states of a resource.
     */
    private ProvisioningState provisioningState;

    /*
     * The description property.
     */
    private String description;

    /*
     * Source resource id to verify the reachability path of.
     */
    private String sourceResourceId;

    /*
     * Destination resource id to verify the reachability path of.
     */
    private String destinationResourceId;

    /*
     * IP traffic information.
     */
    private IpTraffic ipTraffic;

    /**
     * Creates an instance of ReachabilityAnalysisIntentProperties class.
     */
    public ReachabilityAnalysisIntentProperties() {
    }

    /**
     * Get the provisioningState property: Provisioning states of a resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: Provisioning states of a resource.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the ReachabilityAnalysisIntentProperties object itself.
     */
    public ReachabilityAnalysisIntentProperties withProvisioningState(ProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get the description property: The description property.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The description property.
     * 
     * @param description the description value to set.
     * @return the ReachabilityAnalysisIntentProperties object itself.
     */
    public ReachabilityAnalysisIntentProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the sourceResourceId property: Source resource id to verify the reachability path of.
     * 
     * @return the sourceResourceId value.
     */
    public String sourceResourceId() {
        return this.sourceResourceId;
    }

    /**
     * Set the sourceResourceId property: Source resource id to verify the reachability path of.
     * 
     * @param sourceResourceId the sourceResourceId value to set.
     * @return the ReachabilityAnalysisIntentProperties object itself.
     */
    public ReachabilityAnalysisIntentProperties withSourceResourceId(String sourceResourceId) {
        this.sourceResourceId = sourceResourceId;
        return this;
    }

    /**
     * Get the destinationResourceId property: Destination resource id to verify the reachability path of.
     * 
     * @return the destinationResourceId value.
     */
    public String destinationResourceId() {
        return this.destinationResourceId;
    }

    /**
     * Set the destinationResourceId property: Destination resource id to verify the reachability path of.
     * 
     * @param destinationResourceId the destinationResourceId value to set.
     * @return the ReachabilityAnalysisIntentProperties object itself.
     */
    public ReachabilityAnalysisIntentProperties withDestinationResourceId(String destinationResourceId) {
        this.destinationResourceId = destinationResourceId;
        return this;
    }

    /**
     * Get the ipTraffic property: IP traffic information.
     * 
     * @return the ipTraffic value.
     */
    public IpTraffic ipTraffic() {
        return this.ipTraffic;
    }

    /**
     * Set the ipTraffic property: IP traffic information.
     * 
     * @param ipTraffic the ipTraffic value to set.
     * @return the ReachabilityAnalysisIntentProperties object itself.
     */
    public ReachabilityAnalysisIntentProperties withIpTraffic(IpTraffic ipTraffic) {
        this.ipTraffic = ipTraffic;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceResourceId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sourceResourceId in model ReachabilityAnalysisIntentProperties"));
        }
        if (destinationResourceId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property destinationResourceId in model ReachabilityAnalysisIntentProperties"));
        }
        if (ipTraffic() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property ipTraffic in model ReachabilityAnalysisIntentProperties"));
        } else {
            ipTraffic().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ReachabilityAnalysisIntentProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceResourceId", this.sourceResourceId);
        jsonWriter.writeStringField("destinationResourceId", this.destinationResourceId);
        jsonWriter.writeJsonField("ipTraffic", this.ipTraffic);
        jsonWriter.writeStringField("provisioningState",
            this.provisioningState == null ? null : this.provisioningState.toString());
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ReachabilityAnalysisIntentProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ReachabilityAnalysisIntentProperties if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ReachabilityAnalysisIntentProperties.
     */
    public static ReachabilityAnalysisIntentProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ReachabilityAnalysisIntentProperties deserializedReachabilityAnalysisIntentProperties
                = new ReachabilityAnalysisIntentProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceResourceId".equals(fieldName)) {
                    deserializedReachabilityAnalysisIntentProperties.sourceResourceId = reader.getString();
                } else if ("destinationResourceId".equals(fieldName)) {
                    deserializedReachabilityAnalysisIntentProperties.destinationResourceId = reader.getString();
                } else if ("ipTraffic".equals(fieldName)) {
                    deserializedReachabilityAnalysisIntentProperties.ipTraffic = IpTraffic.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedReachabilityAnalysisIntentProperties.provisioningState
                        = ProvisioningState.fromString(reader.getString());
                } else if ("description".equals(fieldName)) {
                    deserializedReachabilityAnalysisIntentProperties.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedReachabilityAnalysisIntentProperties;
        });
    }
}
