// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NspLinkInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list NSP link resources. Contains a list of NSP link resources and a URL link to get the
 * next set of results.
 */
@Fluent
public final class NspLinkListResult implements JsonSerializable<NspLinkListResult> {
    /*
     * Gets a page of NSP Link resources.
     */
    private List<NspLinkInner> value;

    /*
     * Gets the URL to get the next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of NspLinkListResult class.
     */
    public NspLinkListResult() {
    }

    /**
     * Get the value property: Gets a page of NSP Link resources.
     * 
     * @return the value value.
     */
    public List<NspLinkInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Gets a page of NSP Link resources.
     * 
     * @param value the value value to set.
     * @return the NspLinkListResult object itself.
     */
    public NspLinkListResult withValue(List<NspLinkInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Gets the URL to get the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Gets the URL to get the next page of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the NspLinkListResult object itself.
     */
    public NspLinkListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspLinkListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspLinkListResult if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the NspLinkListResult.
     */
    public static NspLinkListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspLinkListResult deserializedNspLinkListResult = new NspLinkListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<NspLinkInner> value = reader.readArray(reader1 -> NspLinkInner.fromJson(reader1));
                    deserializedNspLinkListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedNspLinkListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspLinkListResult;
        });
    }
}
