// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Details of NetworkIntentPolicyConfiguration for PrepareNetworkPoliciesRequest.
 */
@Fluent
public final class NetworkIntentPolicyConfiguration implements JsonSerializable<NetworkIntentPolicyConfiguration> {
    /*
     * The name of the Network Intent Policy for storing in target subscription.
     */
    private String networkIntentPolicyName;

    /*
     * Source network intent policy.
     */
    private NetworkIntentPolicy sourceNetworkIntentPolicy;

    /**
     * Creates an instance of NetworkIntentPolicyConfiguration class.
     */
    public NetworkIntentPolicyConfiguration() {
    }

    /**
     * Get the networkIntentPolicyName property: The name of the Network Intent Policy for storing in target
     * subscription.
     * 
     * @return the networkIntentPolicyName value.
     */
    public String networkIntentPolicyName() {
        return this.networkIntentPolicyName;
    }

    /**
     * Set the networkIntentPolicyName property: The name of the Network Intent Policy for storing in target
     * subscription.
     * 
     * @param networkIntentPolicyName the networkIntentPolicyName value to set.
     * @return the NetworkIntentPolicyConfiguration object itself.
     */
    public NetworkIntentPolicyConfiguration withNetworkIntentPolicyName(String networkIntentPolicyName) {
        this.networkIntentPolicyName = networkIntentPolicyName;
        return this;
    }

    /**
     * Get the sourceNetworkIntentPolicy property: Source network intent policy.
     * 
     * @return the sourceNetworkIntentPolicy value.
     */
    public NetworkIntentPolicy sourceNetworkIntentPolicy() {
        return this.sourceNetworkIntentPolicy;
    }

    /**
     * Set the sourceNetworkIntentPolicy property: Source network intent policy.
     * 
     * @param sourceNetworkIntentPolicy the sourceNetworkIntentPolicy value to set.
     * @return the NetworkIntentPolicyConfiguration object itself.
     */
    public NetworkIntentPolicyConfiguration
        withSourceNetworkIntentPolicy(NetworkIntentPolicy sourceNetworkIntentPolicy) {
        this.sourceNetworkIntentPolicy = sourceNetworkIntentPolicy;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceNetworkIntentPolicy() != null) {
            sourceNetworkIntentPolicy().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("networkIntentPolicyName", this.networkIntentPolicyName);
        jsonWriter.writeJsonField("sourceNetworkIntentPolicy", this.sourceNetworkIntentPolicy);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkIntentPolicyConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkIntentPolicyConfiguration if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkIntentPolicyConfiguration.
     */
    public static NetworkIntentPolicyConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkIntentPolicyConfiguration deserializedNetworkIntentPolicyConfiguration
                = new NetworkIntentPolicyConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("networkIntentPolicyName".equals(fieldName)) {
                    deserializedNetworkIntentPolicyConfiguration.networkIntentPolicyName = reader.getString();
                } else if ("sourceNetworkIntentPolicy".equals(fieldName)) {
                    deserializedNetworkIntentPolicyConfiguration.sourceNetworkIntentPolicy
                        = NetworkIntentPolicy.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkIntentPolicyConfiguration;
        });
    }
}
