// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Tier of a load balancer SKU.
 */
public final class LoadBalancerSkuTier extends ExpandableStringEnum<LoadBalancerSkuTier> {
    /**
     * Static value Regional for LoadBalancerSkuTier.
     */
    public static final LoadBalancerSkuTier REGIONAL = fromString("Regional");

    /**
     * Static value Global for LoadBalancerSkuTier.
     */
    public static final LoadBalancerSkuTier GLOBAL = fromString("Global");

    /**
     * Creates a new instance of LoadBalancerSkuTier value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public LoadBalancerSkuTier() {
    }

    /**
     * Creates or finds a LoadBalancerSkuTier from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding LoadBalancerSkuTier.
     */
    public static LoadBalancerSkuTier fromString(String name) {
        return fromString(name, LoadBalancerSkuTier.class);
    }

    /**
     * Gets known LoadBalancerSkuTier values.
     * 
     * @return known LoadBalancerSkuTier values.
     */
    public static Collection<LoadBalancerSkuTier> values() {
        return values(LoadBalancerSkuTier.class);
    }
}
