// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The information about health per rule per backend address.
 */
@Fluent
public final class LoadBalancerHealthPerRulePerBackendAddress
    implements JsonSerializable<LoadBalancerHealthPerRulePerBackendAddress> {
    /*
     * The IP address belonging to the backend address.
     */
    private String ipAddress;

    /*
     * Resource ID of the Network Interface IP Configuration.
     */
    private String networkInterfaceIpConfigurationId;

    /*
     * The current health of the backend instances that is associated to the LB rule.
     */
    private String state;

    /*
     * The explanation of the State
     */
    private String reason;

    /**
     * Creates an instance of LoadBalancerHealthPerRulePerBackendAddress class.
     */
    public LoadBalancerHealthPerRulePerBackendAddress() {
    }

    /**
     * Get the ipAddress property: The IP address belonging to the backend address.
     * 
     * @return the ipAddress value.
     */
    public String ipAddress() {
        return this.ipAddress;
    }

    /**
     * Set the ipAddress property: The IP address belonging to the backend address.
     * 
     * @param ipAddress the ipAddress value to set.
     * @return the LoadBalancerHealthPerRulePerBackendAddress object itself.
     */
    public LoadBalancerHealthPerRulePerBackendAddress withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    /**
     * Get the networkInterfaceIpConfigurationId property: Resource ID of the Network Interface IP Configuration.
     * 
     * @return the networkInterfaceIpConfigurationId value.
     */
    public String networkInterfaceIpConfigurationId() {
        return this.networkInterfaceIpConfigurationId;
    }

    /**
     * Set the networkInterfaceIpConfigurationId property: Resource ID of the Network Interface IP Configuration.
     * 
     * @param networkInterfaceIpConfigurationId the networkInterfaceIpConfigurationId value to set.
     * @return the LoadBalancerHealthPerRulePerBackendAddress object itself.
     */
    public LoadBalancerHealthPerRulePerBackendAddress
        withNetworkInterfaceIpConfigurationId(String networkInterfaceIpConfigurationId) {
        this.networkInterfaceIpConfigurationId = networkInterfaceIpConfigurationId;
        return this;
    }

    /**
     * Get the state property: The current health of the backend instances that is associated to the LB rule.
     * 
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Set the state property: The current health of the backend instances that is associated to the LB rule.
     * 
     * @param state the state value to set.
     * @return the LoadBalancerHealthPerRulePerBackendAddress object itself.
     */
    public LoadBalancerHealthPerRulePerBackendAddress withState(String state) {
        this.state = state;
        return this;
    }

    /**
     * Get the reason property: The explanation of the State.
     * 
     * @return the reason value.
     */
    public String reason() {
        return this.reason;
    }

    /**
     * Set the reason property: The explanation of the State.
     * 
     * @param reason the reason value to set.
     * @return the LoadBalancerHealthPerRulePerBackendAddress object itself.
     */
    public LoadBalancerHealthPerRulePerBackendAddress withReason(String reason) {
        this.reason = reason;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("ipAddress", this.ipAddress);
        jsonWriter.writeStringField("networkInterfaceIPConfigurationId", this.networkInterfaceIpConfigurationId);
        jsonWriter.writeStringField("state", this.state);
        jsonWriter.writeStringField("reason", this.reason);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LoadBalancerHealthPerRulePerBackendAddress from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LoadBalancerHealthPerRulePerBackendAddress if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LoadBalancerHealthPerRulePerBackendAddress.
     */
    public static LoadBalancerHealthPerRulePerBackendAddress fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LoadBalancerHealthPerRulePerBackendAddress deserializedLoadBalancerHealthPerRulePerBackendAddress
                = new LoadBalancerHealthPerRulePerBackendAddress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ipAddress".equals(fieldName)) {
                    deserializedLoadBalancerHealthPerRulePerBackendAddress.ipAddress = reader.getString();
                } else if ("networkInterfaceIPConfigurationId".equals(fieldName)) {
                    deserializedLoadBalancerHealthPerRulePerBackendAddress.networkInterfaceIpConfigurationId
                        = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedLoadBalancerHealthPerRulePerBackendAddress.state = reader.getString();
                } else if ("reason".equals(fieldName)) {
                    deserializedLoadBalancerHealthPerRulePerBackendAddress.reason = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLoadBalancerHealthPerRulePerBackendAddress;
        });
    }
}
