// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ConnectivityConfigurationProperties;
import java.io.IOException;
import java.util.List;

/**
 * The network manager effective connectivity configuration.
 */
@Fluent
public class EffectiveConnectivityConfiguration implements JsonSerializable<EffectiveConnectivityConfiguration> {
    /*
     * Connectivity configuration ID.
     */
    private String id;

    /*
     * Properties of a network manager connectivity configuration
     */
    private ConnectivityConfigurationProperties innerProperties;

    /*
     * Effective configuration groups.
     */
    private List<ConfigurationGroup> configurationGroups;

    /**
     * Creates an instance of EffectiveConnectivityConfiguration class.
     */
    public EffectiveConnectivityConfiguration() {
    }

    /**
     * Get the id property: Connectivity configuration ID.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Connectivity configuration ID.
     * 
     * @param id the id value to set.
     * @return the EffectiveConnectivityConfiguration object itself.
     */
    public EffectiveConnectivityConfiguration withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the innerProperties property: Properties of a network manager connectivity configuration.
     * 
     * @return the innerProperties value.
     */
    private ConnectivityConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Set the innerProperties property: Properties of a network manager connectivity configuration.
     * 
     * @param innerProperties the innerProperties value to set.
     * @return the EffectiveConnectivityConfiguration object itself.
     */
    EffectiveConnectivityConfiguration withInnerProperties(ConnectivityConfigurationProperties innerProperties) {
        this.innerProperties = innerProperties;
        return this;
    }

    /**
     * Get the configurationGroups property: Effective configuration groups.
     * 
     * @return the configurationGroups value.
     */
    public List<ConfigurationGroup> configurationGroups() {
        return this.configurationGroups;
    }

    /**
     * Set the configurationGroups property: Effective configuration groups.
     * 
     * @param configurationGroups the configurationGroups value to set.
     * @return the EffectiveConnectivityConfiguration object itself.
     */
    public EffectiveConnectivityConfiguration withConfigurationGroups(List<ConfigurationGroup> configurationGroups) {
        this.configurationGroups = configurationGroups;
        return this;
    }

    /**
     * Get the description property: A description of the connectivity configuration.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: A description of the connectivity configuration.
     * 
     * @param description the description value to set.
     * @return the EffectiveConnectivityConfiguration object itself.
     */
    public EffectiveConnectivityConfiguration withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectivityConfigurationProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the connectivityTopology property: Connectivity topology type.
     * 
     * @return the connectivityTopology value.
     */
    public ConnectivityTopology connectivityTopology() {
        return this.innerProperties() == null ? null : this.innerProperties().connectivityTopology();
    }

    /**
     * Set the connectivityTopology property: Connectivity topology type.
     * 
     * @param connectivityTopology the connectivityTopology value to set.
     * @return the EffectiveConnectivityConfiguration object itself.
     */
    public EffectiveConnectivityConfiguration withConnectivityTopology(ConnectivityTopology connectivityTopology) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectivityConfigurationProperties();
        }
        this.innerProperties().withConnectivityTopology(connectivityTopology);
        return this;
    }

    /**
     * Get the hubs property: List of hubItems.
     * 
     * @return the hubs value.
     */
    public List<Hub> hubs() {
        return this.innerProperties() == null ? null : this.innerProperties().hubs();
    }

    /**
     * Set the hubs property: List of hubItems.
     * 
     * @param hubs the hubs value to set.
     * @return the EffectiveConnectivityConfiguration object itself.
     */
    public EffectiveConnectivityConfiguration withHubs(List<Hub> hubs) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectivityConfigurationProperties();
        }
        this.innerProperties().withHubs(hubs);
        return this;
    }

    /**
     * Get the isGlobal property: Flag if global mesh is supported.
     * 
     * @return the isGlobal value.
     */
    public IsGlobal isGlobal() {
        return this.innerProperties() == null ? null : this.innerProperties().isGlobal();
    }

    /**
     * Set the isGlobal property: Flag if global mesh is supported.
     * 
     * @param isGlobal the isGlobal value to set.
     * @return the EffectiveConnectivityConfiguration object itself.
     */
    public EffectiveConnectivityConfiguration withIsGlobal(IsGlobal isGlobal) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectivityConfigurationProperties();
        }
        this.innerProperties().withIsGlobal(isGlobal);
        return this;
    }

    /**
     * Get the connectivityCapabilities property: Collection of additional settings to enhance specific topology
     * behaviors of the connectivity configuration resource.
     * 
     * @return the connectivityCapabilities value.
     */
    public ConnectivityConfigurationPropertiesConnectivityCapabilities connectivityCapabilities() {
        return this.innerProperties() == null ? null : this.innerProperties().connectivityCapabilities();
    }

    /**
     * Set the connectivityCapabilities property: Collection of additional settings to enhance specific topology
     * behaviors of the connectivity configuration resource.
     * 
     * @param connectivityCapabilities the connectivityCapabilities value to set.
     * @return the EffectiveConnectivityConfiguration object itself.
     */
    public EffectiveConnectivityConfiguration withConnectivityCapabilities(
        ConnectivityConfigurationPropertiesConnectivityCapabilities connectivityCapabilities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectivityConfigurationProperties();
        }
        this.innerProperties().withConnectivityCapabilities(connectivityCapabilities);
        return this;
    }

    /**
     * Get the appliesToGroups property: Groups for configuration.
     * 
     * @return the appliesToGroups value.
     */
    public List<ConnectivityGroupItem> appliesToGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().appliesToGroups();
    }

    /**
     * Set the appliesToGroups property: Groups for configuration.
     * 
     * @param appliesToGroups the appliesToGroups value to set.
     * @return the EffectiveConnectivityConfiguration object itself.
     */
    public EffectiveConnectivityConfiguration withAppliesToGroups(List<ConnectivityGroupItem> appliesToGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectivityConfigurationProperties();
        }
        this.innerProperties().withAppliesToGroups(appliesToGroups);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the connectivity configuration resource.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the deleteExistingPeering property: Flag if need to remove current existing peerings.
     * 
     * @return the deleteExistingPeering value.
     */
    public DeleteExistingPeering deleteExistingPeering() {
        return this.innerProperties() == null ? null : this.innerProperties().deleteExistingPeering();
    }

    /**
     * Set the deleteExistingPeering property: Flag if need to remove current existing peerings.
     * 
     * @param deleteExistingPeering the deleteExistingPeering value to set.
     * @return the EffectiveConnectivityConfiguration object itself.
     */
    public EffectiveConnectivityConfiguration withDeleteExistingPeering(DeleteExistingPeering deleteExistingPeering) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ConnectivityConfigurationProperties();
        }
        this.innerProperties().withDeleteExistingPeering(deleteExistingPeering);
        return this;
    }

    /**
     * Get the resourceGuid property: Unique identifier for this resource.
     * 
     * @return the resourceGuid value.
     */
    public String resourceGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceGuid();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (configurationGroups() != null) {
            configurationGroups().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeArrayField("configurationGroups", this.configurationGroups,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of EffectiveConnectivityConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of EffectiveConnectivityConfiguration if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the EffectiveConnectivityConfiguration.
     */
    public static EffectiveConnectivityConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            EffectiveConnectivityConfiguration deserializedEffectiveConnectivityConfiguration
                = new EffectiveConnectivityConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedEffectiveConnectivityConfiguration.id = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedEffectiveConnectivityConfiguration.innerProperties
                        = ConnectivityConfigurationProperties.fromJson(reader);
                } else if ("configurationGroups".equals(fieldName)) {
                    List<ConfigurationGroup> configurationGroups
                        = reader.readArray(reader1 -> ConfigurationGroup.fromJson(reader1));
                    deserializedEffectiveConnectivityConfiguration.configurationGroups = configurationGroups;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedEffectiveConnectivityConfiguration;
        });
    }
}
