// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Collection of additional settings to enhance specific topology behaviors of the connectivity configuration resource.
 */
@Fluent
public final class ConnectivityConfigurationPropertiesConnectivityCapabilities
    implements JsonSerializable<ConnectivityConfigurationPropertiesConnectivityCapabilities> {
    /*
     * Option indicating the scale of private endpoints allowed in the connected group of the connectivity
     * configuration.
     */
    private ConnectedGroupPrivateEndpointsScale connectedGroupPrivateEndpointsScale;

    /*
     * Behavior to handle overlapped IP address space among members of the connected group of the connectivity
     * configuration.
     */
    private ConnectedGroupAddressOverlap connectedGroupAddressOverlap;

    /*
     * Option indicating enforcement of peerings created by the connectivity configuration.
     */
    private PeeringEnforcement peeringEnforcement;

    /**
     * Creates an instance of ConnectivityConfigurationPropertiesConnectivityCapabilities class.
     */
    public ConnectivityConfigurationPropertiesConnectivityCapabilities() {
    }

    /**
     * Get the connectedGroupPrivateEndpointsScale property: Option indicating the scale of private endpoints allowed in
     * the connected group of the connectivity configuration.
     * 
     * @return the connectedGroupPrivateEndpointsScale value.
     */
    public ConnectedGroupPrivateEndpointsScale connectedGroupPrivateEndpointsScale() {
        return this.connectedGroupPrivateEndpointsScale;
    }

    /**
     * Set the connectedGroupPrivateEndpointsScale property: Option indicating the scale of private endpoints allowed in
     * the connected group of the connectivity configuration.
     * 
     * @param connectedGroupPrivateEndpointsScale the connectedGroupPrivateEndpointsScale value to set.
     * @return the ConnectivityConfigurationPropertiesConnectivityCapabilities object itself.
     */
    public ConnectivityConfigurationPropertiesConnectivityCapabilities withConnectedGroupPrivateEndpointsScale(
        ConnectedGroupPrivateEndpointsScale connectedGroupPrivateEndpointsScale) {
        this.connectedGroupPrivateEndpointsScale = connectedGroupPrivateEndpointsScale;
        return this;
    }

    /**
     * Get the connectedGroupAddressOverlap property: Behavior to handle overlapped IP address space among members of
     * the connected group of the connectivity configuration.
     * 
     * @return the connectedGroupAddressOverlap value.
     */
    public ConnectedGroupAddressOverlap connectedGroupAddressOverlap() {
        return this.connectedGroupAddressOverlap;
    }

    /**
     * Set the connectedGroupAddressOverlap property: Behavior to handle overlapped IP address space among members of
     * the connected group of the connectivity configuration.
     * 
     * @param connectedGroupAddressOverlap the connectedGroupAddressOverlap value to set.
     * @return the ConnectivityConfigurationPropertiesConnectivityCapabilities object itself.
     */
    public ConnectivityConfigurationPropertiesConnectivityCapabilities
        withConnectedGroupAddressOverlap(ConnectedGroupAddressOverlap connectedGroupAddressOverlap) {
        this.connectedGroupAddressOverlap = connectedGroupAddressOverlap;
        return this;
    }

    /**
     * Get the peeringEnforcement property: Option indicating enforcement of peerings created by the connectivity
     * configuration.
     * 
     * @return the peeringEnforcement value.
     */
    public PeeringEnforcement peeringEnforcement() {
        return this.peeringEnforcement;
    }

    /**
     * Set the peeringEnforcement property: Option indicating enforcement of peerings created by the connectivity
     * configuration.
     * 
     * @param peeringEnforcement the peeringEnforcement value to set.
     * @return the ConnectivityConfigurationPropertiesConnectivityCapabilities object itself.
     */
    public ConnectivityConfigurationPropertiesConnectivityCapabilities
        withPeeringEnforcement(PeeringEnforcement peeringEnforcement) {
        this.peeringEnforcement = peeringEnforcement;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (connectedGroupPrivateEndpointsScale() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property connectedGroupPrivateEndpointsScale in model ConnectivityConfigurationPropertiesConnectivityCapabilities"));
        }
        if (connectedGroupAddressOverlap() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property connectedGroupAddressOverlap in model ConnectivityConfigurationPropertiesConnectivityCapabilities"));
        }
        if (peeringEnforcement() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property peeringEnforcement in model ConnectivityConfigurationPropertiesConnectivityCapabilities"));
        }
    }

    private static final ClientLogger LOGGER
        = new ClientLogger(ConnectivityConfigurationPropertiesConnectivityCapabilities.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("connectedGroupPrivateEndpointsScale",
            this.connectedGroupPrivateEndpointsScale == null
                ? null
                : this.connectedGroupPrivateEndpointsScale.toString());
        jsonWriter.writeStringField("connectedGroupAddressOverlap",
            this.connectedGroupAddressOverlap == null ? null : this.connectedGroupAddressOverlap.toString());
        jsonWriter.writeStringField("peeringEnforcement",
            this.peeringEnforcement == null ? null : this.peeringEnforcement.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ConnectivityConfigurationPropertiesConnectivityCapabilities from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ConnectivityConfigurationPropertiesConnectivityCapabilities if the JsonReader was pointing
     * to an instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the
     * ConnectivityConfigurationPropertiesConnectivityCapabilities.
     */
    public static ConnectivityConfigurationPropertiesConnectivityCapabilities fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            ConnectivityConfigurationPropertiesConnectivityCapabilities deserializedConnectivityConfigurationPropertiesConnectivityCapabilities
                = new ConnectivityConfigurationPropertiesConnectivityCapabilities();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("connectedGroupPrivateEndpointsScale".equals(fieldName)) {
                    deserializedConnectivityConfigurationPropertiesConnectivityCapabilities.connectedGroupPrivateEndpointsScale
                        = ConnectedGroupPrivateEndpointsScale.fromString(reader.getString());
                } else if ("connectedGroupAddressOverlap".equals(fieldName)) {
                    deserializedConnectivityConfigurationPropertiesConnectivityCapabilities.connectedGroupAddressOverlap
                        = ConnectedGroupAddressOverlap.fromString(reader.getString());
                } else if ("peeringEnforcement".equals(fieldName)) {
                    deserializedConnectivityConfigurationPropertiesConnectivityCapabilities.peeringEnforcement
                        = PeeringEnforcement.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedConnectivityConfigurationPropertiesConnectivityCapabilities;
        });
    }
}
