// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Resource that is onboarded to use network security perimeter. Also referred as perimeter associable resource.
 */
@Fluent
public final class PerimeterAssociableResourceInner implements JsonSerializable<PerimeterAssociableResourceInner> {
    /*
     * Properties of the perimeter associable resource.
     */
    private PerimeterAssociableResourceProperties innerProperties;

    /*
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    private String name;

    /*
     * Identifier of the perimeter associable resource.
     */
    private String id;

    /*
     * Resource type.
     */
    private String type;

    /**
     * Creates an instance of PerimeterAssociableResourceInner class.
     */
    public PerimeterAssociableResourceInner() {
    }

    /**
     * Get the innerProperties property: Properties of the perimeter associable resource.
     * 
     * @return the innerProperties value.
     */
    private PerimeterAssociableResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     * 
     * @param name the name value to set.
     * @return the PerimeterAssociableResourceInner object itself.
     */
    public PerimeterAssociableResourceInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the id property: Identifier of the perimeter associable resource.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Get the displayName property: A friendly name for the properties of perimeter associable resources.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Get the resourceType property: Resource type/provider name.
     * 
     * @return the resourceType value.
     */
    public String resourceType() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceType();
    }

    /**
     * Get the publicDnsZones property: Public DNS zone names of the resources.
     * 
     * @return the publicDnsZones value.
     */
    public List<String> publicDnsZones() {
        return this.innerProperties() == null ? null : this.innerProperties().publicDnsZones();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PerimeterAssociableResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PerimeterAssociableResourceInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PerimeterAssociableResourceInner.
     */
    public static PerimeterAssociableResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PerimeterAssociableResourceInner deserializedPerimeterAssociableResourceInner
                = new PerimeterAssociableResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedPerimeterAssociableResourceInner.innerProperties
                        = PerimeterAssociableResourceProperties.fromJson(reader);
                } else if ("name".equals(fieldName)) {
                    deserializedPerimeterAssociableResourceInner.name = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedPerimeterAssociableResourceInner.id = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPerimeterAssociableResourceInner.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPerimeterAssociableResourceInner;
        });
    }
}
