// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.AccessRuleDirection;
import com.azure.resourcemanager.network.models.NspProvisioningState;
import com.azure.resourcemanager.network.models.PerimeterBasedAccessRule;
import com.azure.resourcemanager.network.models.SubscriptionId;
import java.io.IOException;
import java.util.List;

/**
 * Properties of NSP access rule.
 */
@Fluent
public final class NspAccessRuleProperties implements JsonSerializable<NspAccessRuleProperties> {
    /*
     * The provisioning state of the scope assignment resource.
     */
    private NspProvisioningState provisioningState;

    /*
     * Direction that specifies whether the access rules is inbound/outbound.
     */
    private AccessRuleDirection direction;

    /*
     * Inbound address prefixes (IPv4/IPv6)
     */
    private List<String> addressPrefixes;

    /*
     * Outbound rules in fully qualified domain name format.
     */
    private List<String> fullyQualifiedDomainNames;

    /*
     * List of subscription ids
     */
    private List<SubscriptionId> subscriptions;

    /*
     * Rule specified by the perimeter id.
     */
    private List<PerimeterBasedAccessRule> networkSecurityPerimeters;

    /*
     * Outbound rules in email address format. This access rule type is currently unavailable for use.
     */
    private List<String> emailAddresses;

    /*
     * Outbound rules in phone number format. This access rule type is currently unavailable for use.
     */
    private List<String> phoneNumbers;

    /*
     * Inbound rules of type service tag. This access rule type is currently unavailable for use.
     */
    private List<String> serviceTags;

    /**
     * Creates an instance of NspAccessRuleProperties class.
     */
    public NspAccessRuleProperties() {
    }

    /**
     * Get the provisioningState property: The provisioning state of the scope assignment resource.
     * 
     * @return the provisioningState value.
     */
    public NspProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the direction property: Direction that specifies whether the access rules is inbound/outbound.
     * 
     * @return the direction value.
     */
    public AccessRuleDirection direction() {
        return this.direction;
    }

    /**
     * Set the direction property: Direction that specifies whether the access rules is inbound/outbound.
     * 
     * @param direction the direction value to set.
     * @return the NspAccessRuleProperties object itself.
     */
    public NspAccessRuleProperties withDirection(AccessRuleDirection direction) {
        this.direction = direction;
        return this;
    }

    /**
     * Get the addressPrefixes property: Inbound address prefixes (IPv4/IPv6).
     * 
     * @return the addressPrefixes value.
     */
    public List<String> addressPrefixes() {
        return this.addressPrefixes;
    }

    /**
     * Set the addressPrefixes property: Inbound address prefixes (IPv4/IPv6).
     * 
     * @param addressPrefixes the addressPrefixes value to set.
     * @return the NspAccessRuleProperties object itself.
     */
    public NspAccessRuleProperties withAddressPrefixes(List<String> addressPrefixes) {
        this.addressPrefixes = addressPrefixes;
        return this;
    }

    /**
     * Get the fullyQualifiedDomainNames property: Outbound rules in fully qualified domain name format.
     * 
     * @return the fullyQualifiedDomainNames value.
     */
    public List<String> fullyQualifiedDomainNames() {
        return this.fullyQualifiedDomainNames;
    }

    /**
     * Set the fullyQualifiedDomainNames property: Outbound rules in fully qualified domain name format.
     * 
     * @param fullyQualifiedDomainNames the fullyQualifiedDomainNames value to set.
     * @return the NspAccessRuleProperties object itself.
     */
    public NspAccessRuleProperties withFullyQualifiedDomainNames(List<String> fullyQualifiedDomainNames) {
        this.fullyQualifiedDomainNames = fullyQualifiedDomainNames;
        return this;
    }

    /**
     * Get the subscriptions property: List of subscription ids.
     * 
     * @return the subscriptions value.
     */
    public List<SubscriptionId> subscriptions() {
        return this.subscriptions;
    }

    /**
     * Set the subscriptions property: List of subscription ids.
     * 
     * @param subscriptions the subscriptions value to set.
     * @return the NspAccessRuleProperties object itself.
     */
    public NspAccessRuleProperties withSubscriptions(List<SubscriptionId> subscriptions) {
        this.subscriptions = subscriptions;
        return this;
    }

    /**
     * Get the networkSecurityPerimeters property: Rule specified by the perimeter id.
     * 
     * @return the networkSecurityPerimeters value.
     */
    public List<PerimeterBasedAccessRule> networkSecurityPerimeters() {
        return this.networkSecurityPerimeters;
    }

    /**
     * Get the emailAddresses property: Outbound rules in email address format. This access rule type is currently
     * unavailable for use.
     * 
     * @return the emailAddresses value.
     */
    public List<String> emailAddresses() {
        return this.emailAddresses;
    }

    /**
     * Set the emailAddresses property: Outbound rules in email address format. This access rule type is currently
     * unavailable for use.
     * 
     * @param emailAddresses the emailAddresses value to set.
     * @return the NspAccessRuleProperties object itself.
     */
    public NspAccessRuleProperties withEmailAddresses(List<String> emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    /**
     * Get the phoneNumbers property: Outbound rules in phone number format. This access rule type is currently
     * unavailable for use.
     * 
     * @return the phoneNumbers value.
     */
    public List<String> phoneNumbers() {
        return this.phoneNumbers;
    }

    /**
     * Set the phoneNumbers property: Outbound rules in phone number format. This access rule type is currently
     * unavailable for use.
     * 
     * @param phoneNumbers the phoneNumbers value to set.
     * @return the NspAccessRuleProperties object itself.
     */
    public NspAccessRuleProperties withPhoneNumbers(List<String> phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    /**
     * Get the serviceTags property: Inbound rules of type service tag. This access rule type is currently unavailable
     * for use.
     * 
     * @return the serviceTags value.
     */
    public List<String> serviceTags() {
        return this.serviceTags;
    }

    /**
     * Set the serviceTags property: Inbound rules of type service tag. This access rule type is currently unavailable
     * for use.
     * 
     * @param serviceTags the serviceTags value to set.
     * @return the NspAccessRuleProperties object itself.
     */
    public NspAccessRuleProperties withServiceTags(List<String> serviceTags) {
        this.serviceTags = serviceTags;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (subscriptions() != null) {
            subscriptions().forEach(e -> e.validate());
        }
        if (networkSecurityPerimeters() != null) {
            networkSecurityPerimeters().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("direction", this.direction == null ? null : this.direction.toString());
        jsonWriter.writeArrayField("addressPrefixes", this.addressPrefixes,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("fullyQualifiedDomainNames", this.fullyQualifiedDomainNames,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("subscriptions", this.subscriptions, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("emailAddresses", this.emailAddresses,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("phoneNumbers", this.phoneNumbers, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("serviceTags", this.serviceTags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NspAccessRuleProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NspAccessRuleProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NspAccessRuleProperties.
     */
    public static NspAccessRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NspAccessRuleProperties deserializedNspAccessRuleProperties = new NspAccessRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedNspAccessRuleProperties.provisioningState
                        = NspProvisioningState.fromString(reader.getString());
                } else if ("direction".equals(fieldName)) {
                    deserializedNspAccessRuleProperties.direction = AccessRuleDirection.fromString(reader.getString());
                } else if ("addressPrefixes".equals(fieldName)) {
                    List<String> addressPrefixes = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspAccessRuleProperties.addressPrefixes = addressPrefixes;
                } else if ("fullyQualifiedDomainNames".equals(fieldName)) {
                    List<String> fullyQualifiedDomainNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspAccessRuleProperties.fullyQualifiedDomainNames = fullyQualifiedDomainNames;
                } else if ("subscriptions".equals(fieldName)) {
                    List<SubscriptionId> subscriptions = reader.readArray(reader1 -> SubscriptionId.fromJson(reader1));
                    deserializedNspAccessRuleProperties.subscriptions = subscriptions;
                } else if ("networkSecurityPerimeters".equals(fieldName)) {
                    List<PerimeterBasedAccessRule> networkSecurityPerimeters
                        = reader.readArray(reader1 -> PerimeterBasedAccessRule.fromJson(reader1));
                    deserializedNspAccessRuleProperties.networkSecurityPerimeters = networkSecurityPerimeters;
                } else if ("emailAddresses".equals(fieldName)) {
                    List<String> emailAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspAccessRuleProperties.emailAddresses = emailAddresses;
                } else if ("phoneNumbers".equals(fieldName)) {
                    List<String> phoneNumbers = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspAccessRuleProperties.phoneNumbers = phoneNumbers;
                } else if ("serviceTags".equals(fieldName)) {
                    List<String> serviceTags = reader.readArray(reader1 -> reader1.getString());
                    deserializedNspAccessRuleProperties.serviceTags = serviceTags;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNspAccessRuleProperties;
        });
    }
}
