// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.NspProvisioningState;
import com.azure.resourcemanager.network.models.SecurityPerimeterSystemData;
import java.io.IOException;
import java.util.Map;

/**
 * The Network Security Perimeter resource.
 */
@Fluent
public final class NetworkSecurityPerimeterInner extends Resource {
    /*
     * The network security perimeter properties
     */
    private NetworkSecurityPerimeterProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SecurityPerimeterSystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of NetworkSecurityPerimeterInner class.
     */
    public NetworkSecurityPerimeterInner() {
    }

    /**
     * Get the innerProperties property: The network security perimeter properties.
     * 
     * @return the innerProperties value.
     */
    private NetworkSecurityPerimeterProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SecurityPerimeterSystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NetworkSecurityPerimeterInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public NetworkSecurityPerimeterInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the scope assignment resource.
     * 
     * @return the provisioningState value.
     */
    public NspProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the perimeterGuid property: perimeter guid of the network security perimeter.
     * 
     * @return the perimeterGuid value.
     */
    public String perimeterGuid() {
        return this.innerProperties() == null ? null : this.innerProperties().perimeterGuid();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (systemData() != null) {
            systemData().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkSecurityPerimeterInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkSecurityPerimeterInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the NetworkSecurityPerimeterInner.
     */
    public static NetworkSecurityPerimeterInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkSecurityPerimeterInner deserializedNetworkSecurityPerimeterInner
                = new NetworkSecurityPerimeterInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedNetworkSecurityPerimeterInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterInner.innerProperties
                        = NetworkSecurityPerimeterProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedNetworkSecurityPerimeterInner.systemData = SecurityPerimeterSystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkSecurityPerimeterInner;
        });
    }
}
