// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.models.BgpPeerStatusListResultInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteFailoverSingleTestDetailsInner;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteFailoverTestDetailsInner;
import com.azure.resourcemanager.network.fluent.models.GatewayResiliencyInformationInner;
import com.azure.resourcemanager.network.fluent.models.GatewayRouteListResultInner;
import com.azure.resourcemanager.network.fluent.models.GatewayRouteSetsInformationInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayConnectionListEntityInner;
import com.azure.resourcemanager.network.fluent.models.VirtualNetworkGatewayInner;
import com.azure.resourcemanager.network.fluent.models.VpnClientConnectionHealthDetailListResultInner;
import com.azure.resourcemanager.network.fluent.models.VpnClientIPsecParametersInner;
import com.azure.resourcemanager.network.models.ExpressRouteFailoverStopApiParameters;
import com.azure.resourcemanager.network.models.P2SVpnConnectionRequest;
import com.azure.resourcemanager.network.models.TagsObject;
import com.azure.resourcemanager.network.models.VirtualNetworkGatewayMigrationParameters;
import com.azure.resourcemanager.network.models.VpnClientParameters;
import com.azure.resourcemanager.network.models.VpnDeviceScriptParameters;
import com.azure.resourcemanager.network.models.VpnPacketCaptureStartParameters;
import com.azure.resourcemanager.network.models.VpnPacketCaptureStopParameters;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import java.nio.ByteBuffer;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in VirtualNetworkGatewaysClient.
 */
public interface VirtualNetworkGatewaysClient
    extends InnerSupportsGet<VirtualNetworkGatewayInner>, InnerSupportsDelete<Void> {
    /**
     * Creates or updates a virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to create or update virtual network gateway operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a common class for general resource information along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName, VirtualNetworkGatewayInner parameters);

    /**
     * Creates or updates a virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to create or update virtual network gateway operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a common class for general resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner> beginCreateOrUpdateAsync(
        String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGatewayInner parameters);

    /**
     * Creates or updates a virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to create or update virtual network gateway operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a common class for general resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner> beginCreateOrUpdate(
        String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGatewayInner parameters);

    /**
     * Creates or updates a virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to create or update virtual network gateway operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a common class for general resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner> beginCreateOrUpdate(
        String resourceGroupName, String virtualNetworkGatewayName, VirtualNetworkGatewayInner parameters,
        Context context);

    /**
     * Creates or updates a virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to create or update virtual network gateway operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a common class for general resource information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualNetworkGatewayInner> createOrUpdateAsync(String resourceGroupName, String virtualNetworkGatewayName,
        VirtualNetworkGatewayInner parameters);

    /**
     * Creates or updates a virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to create or update virtual network gateway operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a common class for general resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualNetworkGatewayInner createOrUpdate(String resourceGroupName, String virtualNetworkGatewayName,
        VirtualNetworkGatewayInner parameters);

    /**
     * Creates or updates a virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to create or update virtual network gateway operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a common class for general resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualNetworkGatewayInner createOrUpdate(String resourceGroupName, String virtualNetworkGatewayName,
        VirtualNetworkGatewayInner parameters, Context context);

    /**
     * Gets the specified virtual network gateway by resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified virtual network gateway by resource group along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<VirtualNetworkGatewayInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Gets the specified virtual network gateway by resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified virtual network gateway by resource group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualNetworkGatewayInner> getByResourceGroupAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Gets the specified virtual network gateway by resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified virtual network gateway by resource group along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<VirtualNetworkGatewayInner> getByResourceGroupWithResponse(String resourceGroupName,
        String virtualNetworkGatewayName, Context context);

    /**
     * Gets the specified virtual network gateway by resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified virtual network gateway by resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualNetworkGatewayInner getByResourceGroup(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Deletes the specified virtual network gateway.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Deletes the specified virtual network gateway.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Deletes the specified virtual network gateway.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Deletes the specified virtual network gateway.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String virtualNetworkGatewayName,
        Context context);

    /**
     * Deletes the specified virtual network gateway.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Deletes the specified virtual network gateway.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Deletes the specified virtual network gateway.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String virtualNetworkGatewayName, Context context);

    /**
     * Updates a virtual network gateway tags.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to update virtual network gateway tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a common class for general resource information along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> updateTagsWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName, TagsObject parameters);

    /**
     * Updates a virtual network gateway tags.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to update virtual network gateway tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a common class for general resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner>
        beginUpdateTagsAsync(String resourceGroupName, String virtualNetworkGatewayName, TagsObject parameters);

    /**
     * Updates a virtual network gateway tags.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to update virtual network gateway tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a common class for general resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner>
        beginUpdateTags(String resourceGroupName, String virtualNetworkGatewayName, TagsObject parameters);

    /**
     * Updates a virtual network gateway tags.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to update virtual network gateway tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a common class for general resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner> beginUpdateTags(
        String resourceGroupName, String virtualNetworkGatewayName, TagsObject parameters, Context context);

    /**
     * Updates a virtual network gateway tags.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to update virtual network gateway tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a common class for general resource information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualNetworkGatewayInner> updateTagsAsync(String resourceGroupName, String virtualNetworkGatewayName,
        TagsObject parameters);

    /**
     * Updates a virtual network gateway tags.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to update virtual network gateway tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a common class for general resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualNetworkGatewayInner updateTags(String resourceGroupName, String virtualNetworkGatewayName,
        TagsObject parameters);

    /**
     * Updates a virtual network gateway tags.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to update virtual network gateway tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a common class for general resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualNetworkGatewayInner updateTags(String resourceGroupName, String virtualNetworkGatewayName,
        TagsObject parameters, Context context);

    /**
     * Gets all virtual network gateways by resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all virtual network gateways by resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<VirtualNetworkGatewayInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Gets all virtual network gateways by resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all virtual network gateways by resource group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VirtualNetworkGatewayInner> listByResourceGroup(String resourceGroupName);

    /**
     * Gets all virtual network gateways by resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all virtual network gateways by resource group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VirtualNetworkGatewayInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Gets all the connections in a virtual network gateway.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the connections in a virtual network gateway as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<VirtualNetworkGatewayConnectionListEntityInner> listConnectionsAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Gets all the connections in a virtual network gateway.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the connections in a virtual network gateway as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VirtualNetworkGatewayConnectionListEntityInner> listConnections(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Gets all the connections in a virtual network gateway.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all the connections in a virtual network gateway as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<VirtualNetworkGatewayConnectionListEntityInner> listConnections(String resourceGroupName,
        String virtualNetworkGatewayName, Context context);

    /**
     * Resets the primary of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param gatewayVip Virtual network gateway vip address supplied to the begin reset of the active-active feature
     * enabled gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a common class for general resource information along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> resetWithResponseAsync(String resourceGroupName, String virtualNetworkGatewayName,
        String gatewayVip);

    /**
     * Resets the primary of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param gatewayVip Virtual network gateway vip address supplied to the begin reset of the active-active feature
     * enabled gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a common class for general resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner>
        beginResetAsync(String resourceGroupName, String virtualNetworkGatewayName, String gatewayVip);

    /**
     * Resets the primary of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of a common class for general resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner>
        beginResetAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Resets the primary of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a common class for general resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner> beginReset(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Resets the primary of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param gatewayVip Virtual network gateway vip address supplied to the begin reset of the active-active feature
     * enabled gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of a common class for general resource information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VirtualNetworkGatewayInner>, VirtualNetworkGatewayInner> beginReset(String resourceGroupName,
        String virtualNetworkGatewayName, String gatewayVip, Context context);

    /**
     * Resets the primary of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param gatewayVip Virtual network gateway vip address supplied to the begin reset of the active-active feature
     * enabled gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a common class for general resource information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualNetworkGatewayInner> resetAsync(String resourceGroupName, String virtualNetworkGatewayName,
        String gatewayVip);

    /**
     * Resets the primary of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a common class for general resource information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VirtualNetworkGatewayInner> resetAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Resets the primary of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a common class for general resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualNetworkGatewayInner reset(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Resets the primary of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param gatewayVip Virtual network gateway vip address supplied to the begin reset of the active-active feature
     * enabled gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a common class for general resource information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VirtualNetworkGatewayInner reset(String resourceGroupName, String virtualNetworkGatewayName, String gatewayVip,
        Context context);

    /**
     * Resets the VPN client shared key of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> resetVpnClientSharedKeyWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Resets the VPN client shared key of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginResetVpnClientSharedKeyAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Resets the VPN client shared key of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginResetVpnClientSharedKey(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Resets the VPN client shared key of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginResetVpnClientSharedKey(String resourceGroupName,
        String virtualNetworkGatewayName, Context context);

    /**
     * Resets the VPN client shared key of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> resetVpnClientSharedKeyAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Resets the VPN client shared key of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void resetVpnClientSharedKey(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Resets the VPN client shared key of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void resetVpnClientSharedKey(String resourceGroupName, String virtualNetworkGatewayName, Context context);

    /**
     * Generates VPN client package for P2S client of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to the generate virtual network gateway VPN client package operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> generatevpnclientpackageWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName, VpnClientParameters parameters);

    /**
     * Generates VPN client package for P2S client of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to the generate virtual network gateway VPN client package operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<String>, String> beginGeneratevpnclientpackageAsync(String resourceGroupName,
        String virtualNetworkGatewayName, VpnClientParameters parameters);

    /**
     * Generates VPN client package for P2S client of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to the generate virtual network gateway VPN client package operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<String>, String> beginGeneratevpnclientpackage(String resourceGroupName,
        String virtualNetworkGatewayName, VpnClientParameters parameters);

    /**
     * Generates VPN client package for P2S client of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to the generate virtual network gateway VPN client package operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<String>, String> beginGeneratevpnclientpackage(String resourceGroupName,
        String virtualNetworkGatewayName, VpnClientParameters parameters, Context context);

    /**
     * Generates VPN client package for P2S client of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to the generate virtual network gateway VPN client package operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<String> generatevpnclientpackageAsync(String resourceGroupName, String virtualNetworkGatewayName,
        VpnClientParameters parameters);

    /**
     * Generates VPN client package for P2S client of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to the generate virtual network gateway VPN client package operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String generatevpnclientpackage(String resourceGroupName, String virtualNetworkGatewayName,
        VpnClientParameters parameters);

    /**
     * Generates VPN client package for P2S client of the virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to the generate virtual network gateway VPN client package operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String generatevpnclientpackage(String resourceGroupName, String virtualNetworkGatewayName,
        VpnClientParameters parameters, Context context);

    /**
     * Generates VPN profile for P2S client of the virtual network gateway in the specified resource group. Used for
     * IKEV2 and radius based authentication.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to the generate virtual network gateway VPN client package operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> generateVpnProfileWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName, VpnClientParameters parameters);

    /**
     * Generates VPN profile for P2S client of the virtual network gateway in the specified resource group. Used for
     * IKEV2 and radius based authentication.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to the generate virtual network gateway VPN client package operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<String>, String> beginGenerateVpnProfileAsync(String resourceGroupName,
        String virtualNetworkGatewayName, VpnClientParameters parameters);

    /**
     * Generates VPN profile for P2S client of the virtual network gateway in the specified resource group. Used for
     * IKEV2 and radius based authentication.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to the generate virtual network gateway VPN client package operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<String>, String> beginGenerateVpnProfile(String resourceGroupName,
        String virtualNetworkGatewayName, VpnClientParameters parameters);

    /**
     * Generates VPN profile for P2S client of the virtual network gateway in the specified resource group. Used for
     * IKEV2 and radius based authentication.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to the generate virtual network gateway VPN client package operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<String>, String> beginGenerateVpnProfile(String resourceGroupName,
        String virtualNetworkGatewayName, VpnClientParameters parameters, Context context);

    /**
     * Generates VPN profile for P2S client of the virtual network gateway in the specified resource group. Used for
     * IKEV2 and radius based authentication.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to the generate virtual network gateway VPN client package operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<String> generateVpnProfileAsync(String resourceGroupName, String virtualNetworkGatewayName,
        VpnClientParameters parameters);

    /**
     * Generates VPN profile for P2S client of the virtual network gateway in the specified resource group. Used for
     * IKEV2 and radius based authentication.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to the generate virtual network gateway VPN client package operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String generateVpnProfile(String resourceGroupName, String virtualNetworkGatewayName,
        VpnClientParameters parameters);

    /**
     * Generates VPN profile for P2S client of the virtual network gateway in the specified resource group. Used for
     * IKEV2 and radius based authentication.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Parameters supplied to the generate virtual network gateway VPN client package operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String generateVpnProfile(String resourceGroupName, String virtualNetworkGatewayName,
        VpnClientParameters parameters, Context context);

    /**
     * Gets pre-generated VPN profile for P2S client of the virtual network gateway in the specified resource group. The
     * profile needs to be generated first using generateVpnProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return pre-generated VPN profile for P2S client of the virtual network gateway in the specified resource group
     * along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getVpnProfilePackageUrlWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Gets pre-generated VPN profile for P2S client of the virtual network gateway in the specified resource group. The
     * profile needs to be generated first using generateVpnProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of pre-generated VPN profile for P2S client of the virtual network
     * gateway in the specified resource group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<String>, String> beginGetVpnProfilePackageUrlAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Gets pre-generated VPN profile for P2S client of the virtual network gateway in the specified resource group. The
     * profile needs to be generated first using generateVpnProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of pre-generated VPN profile for P2S client of the virtual network
     * gateway in the specified resource group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<String>, String> beginGetVpnProfilePackageUrl(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Gets pre-generated VPN profile for P2S client of the virtual network gateway in the specified resource group. The
     * profile needs to be generated first using generateVpnProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of pre-generated VPN profile for P2S client of the virtual network
     * gateway in the specified resource group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<String>, String> beginGetVpnProfilePackageUrl(String resourceGroupName,
        String virtualNetworkGatewayName, Context context);

    /**
     * Gets pre-generated VPN profile for P2S client of the virtual network gateway in the specified resource group. The
     * profile needs to be generated first using generateVpnProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return pre-generated VPN profile for P2S client of the virtual network gateway in the specified resource group
     * on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<String> getVpnProfilePackageUrlAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Gets pre-generated VPN profile for P2S client of the virtual network gateway in the specified resource group. The
     * profile needs to be generated first using generateVpnProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return pre-generated VPN profile for P2S client of the virtual network gateway in the specified resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String getVpnProfilePackageUrl(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Gets pre-generated VPN profile for P2S client of the virtual network gateway in the specified resource group. The
     * profile needs to be generated first using generateVpnProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return pre-generated VPN profile for P2S client of the virtual network gateway in the specified resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String getVpnProfilePackageUrl(String resourceGroupName, String virtualNetworkGatewayName, Context context);

    /**
     * The GetBgpPeerStatus operation retrieves the status of all BGP peers.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peer The IP address of the peer to retrieve the status of.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for list BGP peer status API service call along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getBgpPeerStatusWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName, String peer);

    /**
     * The GetBgpPeerStatus operation retrieves the status of all BGP peers.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peer The IP address of the peer to retrieve the status of.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of response for list BGP peer status API service call.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<BgpPeerStatusListResultInner>, BgpPeerStatusListResultInner>
        beginGetBgpPeerStatusAsync(String resourceGroupName, String virtualNetworkGatewayName, String peer);

    /**
     * The GetBgpPeerStatus operation retrieves the status of all BGP peers.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of response for list BGP peer status API service call.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<BgpPeerStatusListResultInner>, BgpPeerStatusListResultInner>
        beginGetBgpPeerStatusAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * The GetBgpPeerStatus operation retrieves the status of all BGP peers.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of response for list BGP peer status API service call.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<BgpPeerStatusListResultInner>, BgpPeerStatusListResultInner>
        beginGetBgpPeerStatus(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * The GetBgpPeerStatus operation retrieves the status of all BGP peers.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peer The IP address of the peer to retrieve the status of.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of response for list BGP peer status API service call.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<BgpPeerStatusListResultInner>, BgpPeerStatusListResultInner>
        beginGetBgpPeerStatus(String resourceGroupName, String virtualNetworkGatewayName, String peer, Context context);

    /**
     * The GetBgpPeerStatus operation retrieves the status of all BGP peers.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peer The IP address of the peer to retrieve the status of.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for list BGP peer status API service call on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BgpPeerStatusListResultInner> getBgpPeerStatusAsync(String resourceGroupName, String virtualNetworkGatewayName,
        String peer);

    /**
     * The GetBgpPeerStatus operation retrieves the status of all BGP peers.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for list BGP peer status API service call on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<BgpPeerStatusListResultInner> getBgpPeerStatusAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * The GetBgpPeerStatus operation retrieves the status of all BGP peers.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for list BGP peer status API service call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BgpPeerStatusListResultInner getBgpPeerStatus(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * The GetBgpPeerStatus operation retrieves the status of all BGP peers.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peer The IP address of the peer to retrieve the status of.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for list BGP peer status API service call.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    BgpPeerStatusListResultInner getBgpPeerStatus(String resourceGroupName, String virtualNetworkGatewayName,
        String peer, Context context);

    /**
     * Gets a xml format representation for supported vpn devices.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a xml format representation for supported vpn devices along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<String>> supportedVpnDevicesWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Gets a xml format representation for supported vpn devices.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a xml format representation for supported vpn devices on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<String> supportedVpnDevicesAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Gets a xml format representation for supported vpn devices.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a xml format representation for supported vpn devices along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<String> supportedVpnDevicesWithResponse(String resourceGroupName, String virtualNetworkGatewayName,
        Context context);

    /**
     * Gets a xml format representation for supported vpn devices.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a xml format representation for supported vpn devices.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String supportedVpnDevices(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * This operation retrieves a list of routes the virtual network gateway has learned, including routes learned from
     * BGP peers.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of virtual network gateway routes along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getLearnedRoutesWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * This operation retrieves a list of routes the virtual network gateway has learned, including routes learned from
     * BGP peers.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of list of virtual network gateway routes.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<GatewayRouteListResultInner>, GatewayRouteListResultInner>
        beginGetLearnedRoutesAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * This operation retrieves a list of routes the virtual network gateway has learned, including routes learned from
     * BGP peers.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of list of virtual network gateway routes.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GatewayRouteListResultInner>, GatewayRouteListResultInner>
        beginGetLearnedRoutes(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * This operation retrieves a list of routes the virtual network gateway has learned, including routes learned from
     * BGP peers.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of list of virtual network gateway routes.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GatewayRouteListResultInner>, GatewayRouteListResultInner>
        beginGetLearnedRoutes(String resourceGroupName, String virtualNetworkGatewayName, Context context);

    /**
     * This operation retrieves a list of routes the virtual network gateway has learned, including routes learned from
     * BGP peers.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of virtual network gateway routes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GatewayRouteListResultInner> getLearnedRoutesAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * This operation retrieves a list of routes the virtual network gateway has learned, including routes learned from
     * BGP peers.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of virtual network gateway routes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GatewayRouteListResultInner getLearnedRoutes(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * This operation retrieves a list of routes the virtual network gateway has learned, including routes learned from
     * BGP peers.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of virtual network gateway routes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GatewayRouteListResultInner getLearnedRoutes(String resourceGroupName, String virtualNetworkGatewayName,
        Context context);

    /**
     * This operation retrieves a list of routes the virtual network gateway is advertising to the specified peer.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peer The IP address of the peer.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of virtual network gateway routes along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getAdvertisedRoutesWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName, String peer);

    /**
     * This operation retrieves a list of routes the virtual network gateway is advertising to the specified peer.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peer The IP address of the peer.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of list of virtual network gateway routes.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<GatewayRouteListResultInner>, GatewayRouteListResultInner>
        beginGetAdvertisedRoutesAsync(String resourceGroupName, String virtualNetworkGatewayName, String peer);

    /**
     * This operation retrieves a list of routes the virtual network gateway is advertising to the specified peer.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peer The IP address of the peer.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of list of virtual network gateway routes.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GatewayRouteListResultInner>, GatewayRouteListResultInner>
        beginGetAdvertisedRoutes(String resourceGroupName, String virtualNetworkGatewayName, String peer);

    /**
     * This operation retrieves a list of routes the virtual network gateway is advertising to the specified peer.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peer The IP address of the peer.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of list of virtual network gateway routes.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GatewayRouteListResultInner>, GatewayRouteListResultInner> beginGetAdvertisedRoutes(
        String resourceGroupName, String virtualNetworkGatewayName, String peer, Context context);

    /**
     * This operation retrieves a list of routes the virtual network gateway is advertising to the specified peer.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peer The IP address of the peer.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of virtual network gateway routes on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GatewayRouteListResultInner> getAdvertisedRoutesAsync(String resourceGroupName,
        String virtualNetworkGatewayName, String peer);

    /**
     * This operation retrieves a list of routes the virtual network gateway is advertising to the specified peer.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peer The IP address of the peer.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of virtual network gateway routes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GatewayRouteListResultInner getAdvertisedRoutes(String resourceGroupName, String virtualNetworkGatewayName,
        String peer);

    /**
     * This operation retrieves a list of routes the virtual network gateway is advertising to the specified peer.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peer The IP address of the peer.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of virtual network gateway routes.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GatewayRouteListResultInner getAdvertisedRoutes(String resourceGroupName, String virtualNetworkGatewayName,
        String peer, Context context);

    /**
     * This operation retrieves the resiliency information for an Express Route Gateway, including the gateway's current
     * resiliency score and recommendations to further improve the score.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param attemptRefresh Attempt to recalculate the Resiliency Information for the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Resiliency Information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getResiliencyInformationWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName, Boolean attemptRefresh);

    /**
     * This operation retrieves the resiliency information for an Express Route Gateway, including the gateway's current
     * resiliency score and recommendations to further improve the score.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param attemptRefresh Attempt to recalculate the Resiliency Information for the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of gateway Resiliency Information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<GatewayResiliencyInformationInner>, GatewayResiliencyInformationInner>
        beginGetResiliencyInformationAsync(String resourceGroupName, String virtualNetworkGatewayName,
            Boolean attemptRefresh);

    /**
     * This operation retrieves the resiliency information for an Express Route Gateway, including the gateway's current
     * resiliency score and recommendations to further improve the score.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of gateway Resiliency Information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<GatewayResiliencyInformationInner>, GatewayResiliencyInformationInner>
        beginGetResiliencyInformationAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * This operation retrieves the resiliency information for an Express Route Gateway, including the gateway's current
     * resiliency score and recommendations to further improve the score.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of gateway Resiliency Information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GatewayResiliencyInformationInner>, GatewayResiliencyInformationInner>
        beginGetResiliencyInformation(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * This operation retrieves the resiliency information for an Express Route Gateway, including the gateway's current
     * resiliency score and recommendations to further improve the score.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param attemptRefresh Attempt to recalculate the Resiliency Information for the gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of gateway Resiliency Information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GatewayResiliencyInformationInner>, GatewayResiliencyInformationInner>
        beginGetResiliencyInformation(String resourceGroupName, String virtualNetworkGatewayName,
            Boolean attemptRefresh, Context context);

    /**
     * This operation retrieves the resiliency information for an Express Route Gateway, including the gateway's current
     * resiliency score and recommendations to further improve the score.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param attemptRefresh Attempt to recalculate the Resiliency Information for the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Resiliency Information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GatewayResiliencyInformationInner> getResiliencyInformationAsync(String resourceGroupName,
        String virtualNetworkGatewayName, Boolean attemptRefresh);

    /**
     * This operation retrieves the resiliency information for an Express Route Gateway, including the gateway's current
     * resiliency score and recommendations to further improve the score.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Resiliency Information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GatewayResiliencyInformationInner> getResiliencyInformationAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * This operation retrieves the resiliency information for an Express Route Gateway, including the gateway's current
     * resiliency score and recommendations to further improve the score.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Resiliency Information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GatewayResiliencyInformationInner getResiliencyInformation(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * This operation retrieves the resiliency information for an Express Route Gateway, including the gateway's current
     * resiliency score and recommendations to further improve the score.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param attemptRefresh Attempt to recalculate the Resiliency Information for the gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Resiliency Information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GatewayResiliencyInformationInner getResiliencyInformation(String resourceGroupName,
        String virtualNetworkGatewayName, Boolean attemptRefresh, Context context);

    /**
     * This operation retrieves the route set information for an Express Route Gateway based on their resiliency.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param attemptRefresh Attempt to recalculate the Route Sets Information for the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Route Sets Information along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getRoutesInformationWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName, Boolean attemptRefresh);

    /**
     * This operation retrieves the route set information for an Express Route Gateway based on their resiliency.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param attemptRefresh Attempt to recalculate the Route Sets Information for the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of gateway Route Sets Information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<GatewayRouteSetsInformationInner>, GatewayRouteSetsInformationInner>
        beginGetRoutesInformationAsync(String resourceGroupName, String virtualNetworkGatewayName,
            Boolean attemptRefresh);

    /**
     * This operation retrieves the route set information for an Express Route Gateway based on their resiliency.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of gateway Route Sets Information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<GatewayRouteSetsInformationInner>, GatewayRouteSetsInformationInner>
        beginGetRoutesInformationAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * This operation retrieves the route set information for an Express Route Gateway based on their resiliency.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of gateway Route Sets Information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GatewayRouteSetsInformationInner>, GatewayRouteSetsInformationInner>
        beginGetRoutesInformation(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * This operation retrieves the route set information for an Express Route Gateway based on their resiliency.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param attemptRefresh Attempt to recalculate the Route Sets Information for the gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of gateway Route Sets Information.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<GatewayRouteSetsInformationInner>, GatewayRouteSetsInformationInner>
        beginGetRoutesInformation(String resourceGroupName, String virtualNetworkGatewayName, Boolean attemptRefresh,
            Context context);

    /**
     * This operation retrieves the route set information for an Express Route Gateway based on their resiliency.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param attemptRefresh Attempt to recalculate the Route Sets Information for the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Route Sets Information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GatewayRouteSetsInformationInner> getRoutesInformationAsync(String resourceGroupName,
        String virtualNetworkGatewayName, Boolean attemptRefresh);

    /**
     * This operation retrieves the route set information for an Express Route Gateway based on their resiliency.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Route Sets Information on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<GatewayRouteSetsInformationInner> getRoutesInformationAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * This operation retrieves the route set information for an Express Route Gateway based on their resiliency.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Route Sets Information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GatewayRouteSetsInformationInner getRoutesInformation(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * This operation retrieves the route set information for an Express Route Gateway based on their resiliency.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param attemptRefresh Attempt to recalculate the Route Sets Information for the gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Route Sets Information.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    GatewayRouteSetsInformationInner getRoutesInformation(String resourceGroupName, String virtualNetworkGatewayName,
        Boolean attemptRefresh, Context context);

    /**
     * The Set VpnclientIpsecParameters operation sets the vpnclient ipsec policy for P2S client of virtual network
     * gateway in the specified resource group through Network resource provider.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param vpnclientIpsecParams Parameters supplied to the Begin Set vpnclient ipsec parameters of Virtual Network
     * Gateway P2S client operation through Network resource provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an IPSec parameters for a virtual network gateway P2S connection along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> setVpnclientIpsecParametersWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName, VpnClientIPsecParametersInner vpnclientIpsecParams);

    /**
     * The Set VpnclientIpsecParameters operation sets the vpnclient ipsec policy for P2S client of virtual network
     * gateway in the specified resource group through Network resource provider.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param vpnclientIpsecParams Parameters supplied to the Begin Set vpnclient ipsec parameters of Virtual Network
     * Gateway P2S client operation through Network resource provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an IPSec parameters for a virtual network gateway P2S connection.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VpnClientIPsecParametersInner>, VpnClientIPsecParametersInner>
        beginSetVpnclientIpsecParametersAsync(String resourceGroupName, String virtualNetworkGatewayName,
            VpnClientIPsecParametersInner vpnclientIpsecParams);

    /**
     * The Set VpnclientIpsecParameters operation sets the vpnclient ipsec policy for P2S client of virtual network
     * gateway in the specified resource group through Network resource provider.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param vpnclientIpsecParams Parameters supplied to the Begin Set vpnclient ipsec parameters of Virtual Network
     * Gateway P2S client operation through Network resource provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an IPSec parameters for a virtual network gateway P2S connection.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VpnClientIPsecParametersInner>, VpnClientIPsecParametersInner>
        beginSetVpnclientIpsecParameters(String resourceGroupName, String virtualNetworkGatewayName,
            VpnClientIPsecParametersInner vpnclientIpsecParams);

    /**
     * The Set VpnclientIpsecParameters operation sets the vpnclient ipsec policy for P2S client of virtual network
     * gateway in the specified resource group through Network resource provider.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param vpnclientIpsecParams Parameters supplied to the Begin Set vpnclient ipsec parameters of Virtual Network
     * Gateway P2S client operation through Network resource provider.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an IPSec parameters for a virtual network gateway P2S connection.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VpnClientIPsecParametersInner>, VpnClientIPsecParametersInner>
        beginSetVpnclientIpsecParameters(String resourceGroupName, String virtualNetworkGatewayName,
            VpnClientIPsecParametersInner vpnclientIpsecParams, Context context);

    /**
     * The Set VpnclientIpsecParameters operation sets the vpnclient ipsec policy for P2S client of virtual network
     * gateway in the specified resource group through Network resource provider.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param vpnclientIpsecParams Parameters supplied to the Begin Set vpnclient ipsec parameters of Virtual Network
     * Gateway P2S client operation through Network resource provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an IPSec parameters for a virtual network gateway P2S connection on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VpnClientIPsecParametersInner> setVpnclientIpsecParametersAsync(String resourceGroupName,
        String virtualNetworkGatewayName, VpnClientIPsecParametersInner vpnclientIpsecParams);

    /**
     * The Set VpnclientIpsecParameters operation sets the vpnclient ipsec policy for P2S client of virtual network
     * gateway in the specified resource group through Network resource provider.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param vpnclientIpsecParams Parameters supplied to the Begin Set vpnclient ipsec parameters of Virtual Network
     * Gateway P2S client operation through Network resource provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an IPSec parameters for a virtual network gateway P2S connection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VpnClientIPsecParametersInner setVpnclientIpsecParameters(String resourceGroupName,
        String virtualNetworkGatewayName, VpnClientIPsecParametersInner vpnclientIpsecParams);

    /**
     * The Set VpnclientIpsecParameters operation sets the vpnclient ipsec policy for P2S client of virtual network
     * gateway in the specified resource group through Network resource provider.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param vpnclientIpsecParams Parameters supplied to the Begin Set vpnclient ipsec parameters of Virtual Network
     * Gateway P2S client operation through Network resource provider.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an IPSec parameters for a virtual network gateway P2S connection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VpnClientIPsecParametersInner setVpnclientIpsecParameters(String resourceGroupName,
        String virtualNetworkGatewayName, VpnClientIPsecParametersInner vpnclientIpsecParams, Context context);

    /**
     * The Get VpnclientIpsecParameters operation retrieves information about the vpnclient ipsec policy for P2S client
     * of virtual network gateway in the specified resource group through Network resource provider.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The virtual network gateway name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an IPSec parameters for a virtual network gateway P2S connection along with {@link Response} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getVpnclientIpsecParametersWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * The Get VpnclientIpsecParameters operation retrieves information about the vpnclient ipsec policy for P2S client
     * of virtual network gateway in the specified resource group through Network resource provider.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The virtual network gateway name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of an IPSec parameters for a virtual network gateway P2S connection.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VpnClientIPsecParametersInner>, VpnClientIPsecParametersInner>
        beginGetVpnclientIpsecParametersAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * The Get VpnclientIpsecParameters operation retrieves information about the vpnclient ipsec policy for P2S client
     * of virtual network gateway in the specified resource group through Network resource provider.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The virtual network gateway name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an IPSec parameters for a virtual network gateway P2S connection.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VpnClientIPsecParametersInner>, VpnClientIPsecParametersInner>
        beginGetVpnclientIpsecParameters(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * The Get VpnclientIpsecParameters operation retrieves information about the vpnclient ipsec policy for P2S client
     * of virtual network gateway in the specified resource group through Network resource provider.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The virtual network gateway name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of an IPSec parameters for a virtual network gateway P2S connection.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VpnClientIPsecParametersInner>, VpnClientIPsecParametersInner>
        beginGetVpnclientIpsecParameters(String resourceGroupName, String virtualNetworkGatewayName, Context context);

    /**
     * The Get VpnclientIpsecParameters operation retrieves information about the vpnclient ipsec policy for P2S client
     * of virtual network gateway in the specified resource group through Network resource provider.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The virtual network gateway name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an IPSec parameters for a virtual network gateway P2S connection on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VpnClientIPsecParametersInner> getVpnclientIpsecParametersAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * The Get VpnclientIpsecParameters operation retrieves information about the vpnclient ipsec policy for P2S client
     * of virtual network gateway in the specified resource group through Network resource provider.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The virtual network gateway name.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an IPSec parameters for a virtual network gateway P2S connection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VpnClientIPsecParametersInner getVpnclientIpsecParameters(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * The Get VpnclientIpsecParameters operation retrieves information about the vpnclient ipsec policy for P2S client
     * of virtual network gateway in the specified resource group through Network resource provider.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The virtual network gateway name.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an IPSec parameters for a virtual network gateway P2S connection.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VpnClientIPsecParametersInner getVpnclientIpsecParameters(String resourceGroupName,
        String virtualNetworkGatewayName, Context context);

    /**
     * Gets a xml format representation for vpn device configuration script.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayConnectionName The name of the virtual network gateway connection for which the
     * configuration script is generated.
     * @param parameters Parameters supplied to the generate vpn device script operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a xml format representation for vpn device configuration script along with {@link Response} on successful
     * completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<String>> vpnDeviceConfigurationScriptWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayConnectionName, VpnDeviceScriptParameters parameters);

    /**
     * Gets a xml format representation for vpn device configuration script.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayConnectionName The name of the virtual network gateway connection for which the
     * configuration script is generated.
     * @param parameters Parameters supplied to the generate vpn device script operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a xml format representation for vpn device configuration script on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<String> vpnDeviceConfigurationScriptAsync(String resourceGroupName, String virtualNetworkGatewayConnectionName,
        VpnDeviceScriptParameters parameters);

    /**
     * Gets a xml format representation for vpn device configuration script.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayConnectionName The name of the virtual network gateway connection for which the
     * configuration script is generated.
     * @param parameters Parameters supplied to the generate vpn device script operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a xml format representation for vpn device configuration script along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<String> vpnDeviceConfigurationScriptWithResponse(String resourceGroupName,
        String virtualNetworkGatewayConnectionName, VpnDeviceScriptParameters parameters, Context context);

    /**
     * Gets a xml format representation for vpn device configuration script.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayConnectionName The name of the virtual network gateway connection for which the
     * configuration script is generated.
     * @param parameters Parameters supplied to the generate vpn device script operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a xml format representation for vpn device configuration script.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String vpnDeviceConfigurationScript(String resourceGroupName, String virtualNetworkGatewayConnectionName,
        VpnDeviceScriptParameters parameters);

    /**
     * Starts packet capture on virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Virtual network gateway packet capture parameters supplied to start packet capture on gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.network.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> startPacketCaptureWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName, VpnPacketCaptureStartParameters parameters);

    /**
     * Starts packet capture on virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Virtual network gateway packet capture parameters supplied to start packet capture on gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.network.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<String>, String> beginStartPacketCaptureAsync(String resourceGroupName,
        String virtualNetworkGatewayName, VpnPacketCaptureStartParameters parameters);

    /**
     * Starts packet capture on virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.network.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<String>, String> beginStartPacketCaptureAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Starts packet capture on virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.network.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<String>, String> beginStartPacketCapture(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Starts packet capture on virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Virtual network gateway packet capture parameters supplied to start packet capture on gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.network.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<String>, String> beginStartPacketCapture(String resourceGroupName,
        String virtualNetworkGatewayName, VpnPacketCaptureStartParameters parameters, Context context);

    /**
     * Starts packet capture on virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Virtual network gateway packet capture parameters supplied to start packet capture on gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.network.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<String> startPacketCaptureAsync(String resourceGroupName, String virtualNetworkGatewayName,
        VpnPacketCaptureStartParameters parameters);

    /**
     * Starts packet capture on virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.network.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<String> startPacketCaptureAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Starts packet capture on virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.network.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String startPacketCapture(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Starts packet capture on virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Virtual network gateway packet capture parameters supplied to start packet capture on gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.network.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String startPacketCapture(String resourceGroupName, String virtualNetworkGatewayName,
        VpnPacketCaptureStartParameters parameters, Context context);

    /**
     * Stops packet capture on virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Virtual network gateway packet capture parameters supplied to stop packet capture on gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.network.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> stopPacketCaptureWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName, VpnPacketCaptureStopParameters parameters);

    /**
     * Stops packet capture on virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Virtual network gateway packet capture parameters supplied to stop packet capture on gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.network.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<String>, String> beginStopPacketCaptureAsync(String resourceGroupName,
        String virtualNetworkGatewayName, VpnPacketCaptureStopParameters parameters);

    /**
     * Stops packet capture on virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Virtual network gateway packet capture parameters supplied to stop packet capture on gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.network.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<String>, String> beginStopPacketCapture(String resourceGroupName,
        String virtualNetworkGatewayName, VpnPacketCaptureStopParameters parameters);

    /**
     * Stops packet capture on virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Virtual network gateway packet capture parameters supplied to stop packet capture on gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.network.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<String>, String> beginStopPacketCapture(String resourceGroupName,
        String virtualNetworkGatewayName, VpnPacketCaptureStopParameters parameters, Context context);

    /**
     * Stops packet capture on virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Virtual network gateway packet capture parameters supplied to stop packet capture on gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.network.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<String> stopPacketCaptureAsync(String resourceGroupName, String virtualNetworkGatewayName,
        VpnPacketCaptureStopParameters parameters);

    /**
     * Stops packet capture on virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Virtual network gateway packet capture parameters supplied to stop packet capture on gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.network.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String stopPacketCapture(String resourceGroupName, String virtualNetworkGatewayName,
        VpnPacketCaptureStopParameters parameters);

    /**
     * Stops packet capture on virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param parameters Virtual network gateway packet capture parameters supplied to stop packet capture on gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.resourcemanager.network.models.ErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String stopPacketCapture(String resourceGroupName, String virtualNetworkGatewayName,
        VpnPacketCaptureStopParameters parameters, Context context);

    /**
     * This operation retrieves the details of all the failover tests performed on the gateway for different peering
     * locations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param type The type of failover test.
     * @param fetchLatest Fetch only the latest tests for each peering location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Failover All Test Details along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getFailoverAllTestDetailsWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName, String type, boolean fetchLatest);

    /**
     * This operation retrieves the details of all the failover tests performed on the gateway for different peering
     * locations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param type The type of failover test.
     * @param fetchLatest Fetch only the latest tests for each peering location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of gateway Failover All Test Details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<List<ExpressRouteFailoverTestDetailsInner>>, List<ExpressRouteFailoverTestDetailsInner>>
        beginGetFailoverAllTestDetailsAsync(String resourceGroupName, String virtualNetworkGatewayName, String type,
            boolean fetchLatest);

    /**
     * This operation retrieves the details of all the failover tests performed on the gateway for different peering
     * locations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param type The type of failover test.
     * @param fetchLatest Fetch only the latest tests for each peering location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of gateway Failover All Test Details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<List<ExpressRouteFailoverTestDetailsInner>>, List<ExpressRouteFailoverTestDetailsInner>>
        beginGetFailoverAllTestDetails(String resourceGroupName, String virtualNetworkGatewayName, String type,
            boolean fetchLatest);

    /**
     * This operation retrieves the details of all the failover tests performed on the gateway for different peering
     * locations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param type The type of failover test.
     * @param fetchLatest Fetch only the latest tests for each peering location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of gateway Failover All Test Details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<List<ExpressRouteFailoverTestDetailsInner>>, List<ExpressRouteFailoverTestDetailsInner>>
        beginGetFailoverAllTestDetails(String resourceGroupName, String virtualNetworkGatewayName, String type,
            boolean fetchLatest, Context context);

    /**
     * This operation retrieves the details of all the failover tests performed on the gateway for different peering
     * locations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param type The type of failover test.
     * @param fetchLatest Fetch only the latest tests for each peering location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Failover All Test Details on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<ExpressRouteFailoverTestDetailsInner>> getFailoverAllTestDetailsAsync(String resourceGroupName,
        String virtualNetworkGatewayName, String type, boolean fetchLatest);

    /**
     * This operation retrieves the details of all the failover tests performed on the gateway for different peering
     * locations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param type The type of failover test.
     * @param fetchLatest Fetch only the latest tests for each peering location.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Failover All Test Details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<ExpressRouteFailoverTestDetailsInner> getFailoverAllTestDetails(String resourceGroupName,
        String virtualNetworkGatewayName, String type, boolean fetchLatest);

    /**
     * This operation retrieves the details of all the failover tests performed on the gateway for different peering
     * locations.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param type The type of failover test.
     * @param fetchLatest Fetch only the latest tests for each peering location.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Failover All Test Details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<ExpressRouteFailoverTestDetailsInner> getFailoverAllTestDetails(String resourceGroupName,
        String virtualNetworkGatewayName, String type, boolean fetchLatest, Context context);

    /**
     * This operation retrieves the details of a particular failover test performed on the gateway based on the test
     * Guid.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peeringLocation Peering location of the test.
     * @param failoverTestId The unique Guid value which identifies the test.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Failover Single Test Details Object along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getFailoverSingleTestDetailsWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName, String peeringLocation, String failoverTestId);

    /**
     * This operation retrieves the details of a particular failover test performed on the gateway based on the test
     * Guid.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peeringLocation Peering location of the test.
     * @param failoverTestId The unique Guid value which identifies the test.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of gateway Failover Single Test Details Object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<List<ExpressRouteFailoverSingleTestDetailsInner>>, List<ExpressRouteFailoverSingleTestDetailsInner>>
        beginGetFailoverSingleTestDetailsAsync(String resourceGroupName, String virtualNetworkGatewayName,
            String peeringLocation, String failoverTestId);

    /**
     * This operation retrieves the details of a particular failover test performed on the gateway based on the test
     * Guid.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peeringLocation Peering location of the test.
     * @param failoverTestId The unique Guid value which identifies the test.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of gateway Failover Single Test Details Object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<List<ExpressRouteFailoverSingleTestDetailsInner>>, List<ExpressRouteFailoverSingleTestDetailsInner>>
        beginGetFailoverSingleTestDetails(String resourceGroupName, String virtualNetworkGatewayName,
            String peeringLocation, String failoverTestId);

    /**
     * This operation retrieves the details of a particular failover test performed on the gateway based on the test
     * Guid.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peeringLocation Peering location of the test.
     * @param failoverTestId The unique Guid value which identifies the test.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of gateway Failover Single Test Details Object.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<List<ExpressRouteFailoverSingleTestDetailsInner>>, List<ExpressRouteFailoverSingleTestDetailsInner>>
        beginGetFailoverSingleTestDetails(String resourceGroupName, String virtualNetworkGatewayName,
            String peeringLocation, String failoverTestId, Context context);

    /**
     * This operation retrieves the details of a particular failover test performed on the gateway based on the test
     * Guid.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peeringLocation Peering location of the test.
     * @param failoverTestId The unique Guid value which identifies the test.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Failover Single Test Details Object on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<List<ExpressRouteFailoverSingleTestDetailsInner>> getFailoverSingleTestDetailsAsync(String resourceGroupName,
        String virtualNetworkGatewayName, String peeringLocation, String failoverTestId);

    /**
     * This operation retrieves the details of a particular failover test performed on the gateway based on the test
     * Guid.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peeringLocation Peering location of the test.
     * @param failoverTestId The unique Guid value which identifies the test.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Failover Single Test Details Object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<ExpressRouteFailoverSingleTestDetailsInner> getFailoverSingleTestDetails(String resourceGroupName,
        String virtualNetworkGatewayName, String peeringLocation, String failoverTestId);

    /**
     * This operation retrieves the details of a particular failover test performed on the gateway based on the test
     * Guid.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peeringLocation Peering location of the test.
     * @param failoverTestId The unique Guid value which identifies the test.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return gateway Failover Single Test Details Object.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    List<ExpressRouteFailoverSingleTestDetailsInner> getFailoverSingleTestDetails(String resourceGroupName,
        String virtualNetworkGatewayName, String peeringLocation, String failoverTestId, Context context);

    /**
     * This operation starts failover simulation on the gateway for the specified peering location.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peeringLocation Peering location of the test.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> startExpressRouteSiteFailoverSimulationWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName, String peeringLocation);

    /**
     * This operation starts failover simulation on the gateway for the specified peering location.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peeringLocation Peering location of the test.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<String>, String> beginStartExpressRouteSiteFailoverSimulationAsync(String resourceGroupName,
        String virtualNetworkGatewayName, String peeringLocation);

    /**
     * This operation starts failover simulation on the gateway for the specified peering location.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peeringLocation Peering location of the test.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<String>, String> beginStartExpressRouteSiteFailoverSimulation(String resourceGroupName,
        String virtualNetworkGatewayName, String peeringLocation);

    /**
     * This operation starts failover simulation on the gateway for the specified peering location.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peeringLocation Peering location of the test.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<String>, String> beginStartExpressRouteSiteFailoverSimulation(String resourceGroupName,
        String virtualNetworkGatewayName, String peeringLocation, Context context);

    /**
     * This operation starts failover simulation on the gateway for the specified peering location.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peeringLocation Peering location of the test.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<String> startExpressRouteSiteFailoverSimulationAsync(String resourceGroupName,
        String virtualNetworkGatewayName, String peeringLocation);

    /**
     * This operation starts failover simulation on the gateway for the specified peering location.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peeringLocation Peering location of the test.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String startExpressRouteSiteFailoverSimulation(String resourceGroupName, String virtualNetworkGatewayName,
        String peeringLocation);

    /**
     * This operation starts failover simulation on the gateway for the specified peering location.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param peeringLocation Peering location of the test.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String startExpressRouteSiteFailoverSimulation(String resourceGroupName, String virtualNetworkGatewayName,
        String peeringLocation, Context context);

    /**
     * This operation stops failover simulation on the gateway for the specified peering location.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param stopParameters Virtual network gateway stop simulation parameters supplied to stop failover simulation on
     * gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> stopExpressRouteSiteFailoverSimulationWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName, ExpressRouteFailoverStopApiParameters stopParameters);

    /**
     * This operation stops failover simulation on the gateway for the specified peering location.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param stopParameters Virtual network gateway stop simulation parameters supplied to stop failover simulation on
     * gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<String>, String> beginStopExpressRouteSiteFailoverSimulationAsync(String resourceGroupName,
        String virtualNetworkGatewayName, ExpressRouteFailoverStopApiParameters stopParameters);

    /**
     * This operation stops failover simulation on the gateway for the specified peering location.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param stopParameters Virtual network gateway stop simulation parameters supplied to stop failover simulation on
     * gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<String>, String> beginStopExpressRouteSiteFailoverSimulation(String resourceGroupName,
        String virtualNetworkGatewayName, ExpressRouteFailoverStopApiParameters stopParameters);

    /**
     * This operation stops failover simulation on the gateway for the specified peering location.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param stopParameters Virtual network gateway stop simulation parameters supplied to stop failover simulation on
     * gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<String>, String> beginStopExpressRouteSiteFailoverSimulation(String resourceGroupName,
        String virtualNetworkGatewayName, ExpressRouteFailoverStopApiParameters stopParameters, Context context);

    /**
     * This operation stops failover simulation on the gateway for the specified peering location.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param stopParameters Virtual network gateway stop simulation parameters supplied to stop failover simulation on
     * gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response body on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<String> stopExpressRouteSiteFailoverSimulationAsync(String resourceGroupName, String virtualNetworkGatewayName,
        ExpressRouteFailoverStopApiParameters stopParameters);

    /**
     * This operation stops failover simulation on the gateway for the specified peering location.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param stopParameters Virtual network gateway stop simulation parameters supplied to stop failover simulation on
     * gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String stopExpressRouteSiteFailoverSimulation(String resourceGroupName, String virtualNetworkGatewayName,
        ExpressRouteFailoverStopApiParameters stopParameters);

    /**
     * This operation stops failover simulation on the gateway for the specified peering location.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param stopParameters Virtual network gateway stop simulation parameters supplied to stop failover simulation on
     * gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    String stopExpressRouteSiteFailoverSimulation(String resourceGroupName, String virtualNetworkGatewayName,
        ExpressRouteFailoverStopApiParameters stopParameters, Context context);

    /**
     * Get VPN client connection health detail per P2S client connection of the virtual network gateway in the specified
     * resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return vPN client connection health detail per P2S client connection of the virtual network gateway in the
     * specified resource group along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getVpnclientConnectionHealthWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Get VPN client connection health detail per P2S client connection of the virtual network gateway in the specified
     * resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of vPN client connection health detail per P2S client connection of
     * the virtual network gateway in the specified resource group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VpnClientConnectionHealthDetailListResultInner>, VpnClientConnectionHealthDetailListResultInner>
        beginGetVpnclientConnectionHealthAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Get VPN client connection health detail per P2S client connection of the virtual network gateway in the specified
     * resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of vPN client connection health detail per P2S client connection of
     * the virtual network gateway in the specified resource group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VpnClientConnectionHealthDetailListResultInner>, VpnClientConnectionHealthDetailListResultInner>
        beginGetVpnclientConnectionHealth(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Get VPN client connection health detail per P2S client connection of the virtual network gateway in the specified
     * resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of vPN client connection health detail per P2S client connection of
     * the virtual network gateway in the specified resource group.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VpnClientConnectionHealthDetailListResultInner>, VpnClientConnectionHealthDetailListResultInner>
        beginGetVpnclientConnectionHealth(String resourceGroupName, String virtualNetworkGatewayName, Context context);

    /**
     * Get VPN client connection health detail per P2S client connection of the virtual network gateway in the specified
     * resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return vPN client connection health detail per P2S client connection of the virtual network gateway in the
     * specified resource group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VpnClientConnectionHealthDetailListResultInner> getVpnclientConnectionHealthAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Get VPN client connection health detail per P2S client connection of the virtual network gateway in the specified
     * resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return vPN client connection health detail per P2S client connection of the virtual network gateway in the
     * specified resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VpnClientConnectionHealthDetailListResultInner getVpnclientConnectionHealth(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Get VPN client connection health detail per P2S client connection of the virtual network gateway in the specified
     * resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return vPN client connection health detail per P2S client connection of the virtual network gateway in the
     * specified resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VpnClientConnectionHealthDetailListResultInner getVpnclientConnectionHealth(String resourceGroupName,
        String virtualNetworkGatewayName, Context context);

    /**
     * Disconnect vpn connections of virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param request The parameters are supplied to disconnect vpn connections.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> disconnectVirtualNetworkGatewayVpnConnectionsWithResponseAsync(
        String resourceGroupName, String virtualNetworkGatewayName, P2SVpnConnectionRequest request);

    /**
     * Disconnect vpn connections of virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param request The parameters are supplied to disconnect vpn connections.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDisconnectVirtualNetworkGatewayVpnConnectionsAsync(String resourceGroupName,
        String virtualNetworkGatewayName, P2SVpnConnectionRequest request);

    /**
     * Disconnect vpn connections of virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param request The parameters are supplied to disconnect vpn connections.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDisconnectVirtualNetworkGatewayVpnConnections(String resourceGroupName,
        String virtualNetworkGatewayName, P2SVpnConnectionRequest request);

    /**
     * Disconnect vpn connections of virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param request The parameters are supplied to disconnect vpn connections.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDisconnectVirtualNetworkGatewayVpnConnections(String resourceGroupName,
        String virtualNetworkGatewayName, P2SVpnConnectionRequest request, Context context);

    /**
     * Disconnect vpn connections of virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param request The parameters are supplied to disconnect vpn connections.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> disconnectVirtualNetworkGatewayVpnConnectionsAsync(String resourceGroupName,
        String virtualNetworkGatewayName, P2SVpnConnectionRequest request);

    /**
     * Disconnect vpn connections of virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param request The parameters are supplied to disconnect vpn connections.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void disconnectVirtualNetworkGatewayVpnConnections(String resourceGroupName, String virtualNetworkGatewayName,
        P2SVpnConnectionRequest request);

    /**
     * Disconnect vpn connections of virtual network gateway in the specified resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param virtualNetworkGatewayName The name of the virtual network gateway.
     * @param request The parameters are supplied to disconnect vpn connections.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void disconnectVirtualNetworkGatewayVpnConnections(String resourceGroupName, String virtualNetworkGatewayName,
        P2SVpnConnectionRequest request, Context context);

    /**
     * Trigger prepare migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param migrationParams Parameters supplied to the Begin Prepare migration on basic vpn gateway through Network
     * resource provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> invokePrepareMigrationWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName, VirtualNetworkGatewayMigrationParameters migrationParams);

    /**
     * Trigger prepare migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param migrationParams Parameters supplied to the Begin Prepare migration on basic vpn gateway through Network
     * resource provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginInvokePrepareMigrationAsync(String resourceGroupName,
        String virtualNetworkGatewayName, VirtualNetworkGatewayMigrationParameters migrationParams);

    /**
     * Trigger prepare migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param migrationParams Parameters supplied to the Begin Prepare migration on basic vpn gateway through Network
     * resource provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginInvokePrepareMigration(String resourceGroupName,
        String virtualNetworkGatewayName, VirtualNetworkGatewayMigrationParameters migrationParams);

    /**
     * Trigger prepare migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param migrationParams Parameters supplied to the Begin Prepare migration on basic vpn gateway through Network
     * resource provider.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginInvokePrepareMigration(String resourceGroupName,
        String virtualNetworkGatewayName, VirtualNetworkGatewayMigrationParameters migrationParams, Context context);

    /**
     * Trigger prepare migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param migrationParams Parameters supplied to the Begin Prepare migration on basic vpn gateway through Network
     * resource provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> invokePrepareMigrationAsync(String resourceGroupName, String virtualNetworkGatewayName,
        VirtualNetworkGatewayMigrationParameters migrationParams);

    /**
     * Trigger prepare migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param migrationParams Parameters supplied to the Begin Prepare migration on basic vpn gateway through Network
     * resource provider.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void invokePrepareMigration(String resourceGroupName, String virtualNetworkGatewayName,
        VirtualNetworkGatewayMigrationParameters migrationParams);

    /**
     * Trigger prepare migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param migrationParams Parameters supplied to the Begin Prepare migration on basic vpn gateway through Network
     * resource provider.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void invokePrepareMigration(String resourceGroupName, String virtualNetworkGatewayName,
        VirtualNetworkGatewayMigrationParameters migrationParams, Context context);

    /**
     * Trigger execute migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> invokeExecuteMigrationWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Trigger execute migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginInvokeExecuteMigrationAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Trigger execute migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginInvokeExecuteMigration(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Trigger execute migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginInvokeExecuteMigration(String resourceGroupName,
        String virtualNetworkGatewayName, Context context);

    /**
     * Trigger execute migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> invokeExecuteMigrationAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Trigger execute migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void invokeExecuteMigration(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Trigger execute migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void invokeExecuteMigration(String resourceGroupName, String virtualNetworkGatewayName, Context context);

    /**
     * Trigger commit migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> invokeCommitMigrationWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Trigger commit migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginInvokeCommitMigrationAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Trigger commit migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginInvokeCommitMigration(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Trigger commit migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginInvokeCommitMigration(String resourceGroupName,
        String virtualNetworkGatewayName, Context context);

    /**
     * Trigger commit migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> invokeCommitMigrationAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Trigger commit migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void invokeCommitMigration(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Trigger commit migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void invokeCommitMigration(String resourceGroupName, String virtualNetworkGatewayName, Context context);

    /**
     * Trigger abort migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> invokeAbortMigrationWithResponseAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Trigger abort migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginInvokeAbortMigrationAsync(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Trigger abort migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginInvokeAbortMigration(String resourceGroupName,
        String virtualNetworkGatewayName);

    /**
     * Trigger abort migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginInvokeAbortMigration(String resourceGroupName,
        String virtualNetworkGatewayName, Context context);

    /**
     * Trigger abort migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> invokeAbortMigrationAsync(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Trigger abort migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void invokeAbortMigration(String resourceGroupName, String virtualNetworkGatewayName);

    /**
     * Trigger abort migration for the virtual network gateway.
     * 
     * @param resourceGroupName The resource group name of the virtual network gateway.
     * @param virtualNetworkGatewayName The name of the gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void invokeAbortMigration(String resourceGroupName, String virtualNetworkGatewayName, Context context);
}
