// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.models.NetworkSecurityPerimeterInner;
import com.azure.resourcemanager.network.models.UpdateTagsRequest;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in NetworkSecurityPerimetersClient.
 */
public interface NetworkSecurityPerimetersClient extends InnerSupportsGet<NetworkSecurityPerimeterInner>,
    InnerSupportsListing<NetworkSecurityPerimeterInner>, InnerSupportsDelete<Void> {
    /**
     * Gets the specified network security perimeter by the name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified network security perimeter by the name along with {@link Response} on successful completion
     * of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NetworkSecurityPerimeterInner>> getByResourceGroupWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName);

    /**
     * Gets the specified network security perimeter by the name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified network security perimeter by the name on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkSecurityPerimeterInner> getByResourceGroupAsync(String resourceGroupName,
        String networkSecurityPerimeterName);

    /**
     * Gets the specified network security perimeter by the name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified network security perimeter by the name along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NetworkSecurityPerimeterInner> getByResourceGroupWithResponse(String resourceGroupName,
        String networkSecurityPerimeterName, Context context);

    /**
     * Gets the specified network security perimeter by the name.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified network security perimeter by the name.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkSecurityPerimeterInner getByResourceGroup(String resourceGroupName, String networkSecurityPerimeterName);

    /**
     * Creates or updates a Network Security Perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param parameters Parameter supplied to create or update the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Network Security Perimeter resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NetworkSecurityPerimeterInner>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName, NetworkSecurityPerimeterInner parameters);

    /**
     * Creates or updates a Network Security Perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param parameters Parameter supplied to create or update the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Network Security Perimeter resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkSecurityPerimeterInner> createOrUpdateAsync(String resourceGroupName,
        String networkSecurityPerimeterName, NetworkSecurityPerimeterInner parameters);

    /**
     * Creates or updates a Network Security Perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param parameters Parameter supplied to create or update the network security perimeter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Network Security Perimeter resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NetworkSecurityPerimeterInner> createOrUpdateWithResponse(String resourceGroupName,
        String networkSecurityPerimeterName, NetworkSecurityPerimeterInner parameters, Context context);

    /**
     * Creates or updates a Network Security Perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param parameters Parameter supplied to create or update the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Network Security Perimeter resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkSecurityPerimeterInner createOrUpdate(String resourceGroupName, String networkSecurityPerimeterName,
        NetworkSecurityPerimeterInner parameters);

    /**
     * Deletes a network security perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param forceDeletion Deletes the resource even if it contains any child associations.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName, Boolean forceDeletion);

    /**
     * Deletes a network security perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param forceDeletion Deletes the resource even if it contains any child associations.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkSecurityPerimeterName,
        Boolean forceDeletion);

    /**
     * Deletes a network security perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkSecurityPerimeterName);

    /**
     * Deletes a network security perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkSecurityPerimeterName);

    /**
     * Deletes a network security perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param forceDeletion Deletes the resource even if it contains any child associations.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkSecurityPerimeterName,
        Boolean forceDeletion, Context context);

    /**
     * Deletes a network security perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param forceDeletion Deletes the resource even if it contains any child associations.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String networkSecurityPerimeterName, Boolean forceDeletion);

    /**
     * Deletes a network security perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String networkSecurityPerimeterName);

    /**
     * Deletes a network security perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String networkSecurityPerimeterName);

    /**
     * Deletes a network security perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param forceDeletion Deletes the resource even if it contains any child associations.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String networkSecurityPerimeterName, Boolean forceDeletion, Context context);

    /**
     * Patch Tags for a Network Security Perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param parameters Parameter supplied to the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Network Security Perimeter resource along with {@link Response} on successful completion of
     * {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NetworkSecurityPerimeterInner>> patchWithResponseAsync(String resourceGroupName,
        String networkSecurityPerimeterName, UpdateTagsRequest parameters);

    /**
     * Patch Tags for a Network Security Perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param parameters Parameter supplied to the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Network Security Perimeter resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkSecurityPerimeterInner> patchAsync(String resourceGroupName, String networkSecurityPerimeterName,
        UpdateTagsRequest parameters);

    /**
     * Patch Tags for a Network Security Perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param parameters Parameter supplied to the network security perimeter.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Network Security Perimeter resource along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NetworkSecurityPerimeterInner> patchWithResponse(String resourceGroupName,
        String networkSecurityPerimeterName, UpdateTagsRequest parameters, Context context);

    /**
     * Patch Tags for a Network Security Perimeter.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param networkSecurityPerimeterName The name of the network security perimeter.
     * @param parameters Parameter supplied to the network security perimeter.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Network Security Perimeter resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkSecurityPerimeterInner patch(String resourceGroupName, String networkSecurityPerimeterName,
        UpdateTagsRequest parameters);

    /**
     * List all network security perimeters in a subscription.
     * 
     * @param top An optional query parameter which specifies the maximum number of records to be returned by the
     * server.
     * @param skipToken SkipToken is only used if a previous operation returned a partial result. If a previous response
     * contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies
     * a starting point to use for subsequent calls.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NetworkSecurityPerimeter as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NetworkSecurityPerimeterInner> listAsync(Integer top, String skipToken);

    /**
     * List all network security perimeters in a subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NetworkSecurityPerimeter as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NetworkSecurityPerimeterInner> listAsync();

    /**
     * List all network security perimeters in a subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NetworkSecurityPerimeter as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkSecurityPerimeterInner> list();

    /**
     * List all network security perimeters in a subscription.
     * 
     * @param top An optional query parameter which specifies the maximum number of records to be returned by the
     * server.
     * @param skipToken SkipToken is only used if a previous operation returned a partial result. If a previous response
     * contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies
     * a starting point to use for subsequent calls.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NetworkSecurityPerimeter as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkSecurityPerimeterInner> list(Integer top, String skipToken, Context context);

    /**
     * List network security perimeters in a resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param top An optional query parameter which specifies the maximum number of records to be returned by the
     * server.
     * @param skipToken SkipToken is only used if a previous operation returned a partial result. If a previous response
     * contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies
     * a starting point to use for subsequent calls.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NetworkSecurityPerimeter as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NetworkSecurityPerimeterInner> listByResourceGroupAsync(String resourceGroupName, Integer top,
        String skipToken);

    /**
     * List network security perimeters in a resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NetworkSecurityPerimeter as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NetworkSecurityPerimeterInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * List network security perimeters in a resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NetworkSecurityPerimeter as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkSecurityPerimeterInner> listByResourceGroup(String resourceGroupName);

    /**
     * List network security perimeters in a resource group.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param top An optional query parameter which specifies the maximum number of records to be returned by the
     * server.
     * @param skipToken SkipToken is only used if a previous operation returned a partial result. If a previous response
     * contains a nextLink element, the value of the nextLink element will include a skipToken parameter that specifies
     * a starting point to use for subsequent calls.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return result of the request to list NetworkSecurityPerimeter as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkSecurityPerimeterInner> listByResourceGroup(String resourceGroupName, Integer top,
        String skipToken, Context context);
}
