/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class PacketCaptureSettings
implements JsonSerializable<PacketCaptureSettings> {
    private Integer fileCount;
    private Long fileSizeInBytes;
    private Integer sessionTimeLimitInSeconds;

    public Integer fileCount() {
        return this.fileCount;
    }

    public PacketCaptureSettings withFileCount(Integer fileCount) {
        this.fileCount = fileCount;
        return this;
    }

    public Long fileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public PacketCaptureSettings withFileSizeInBytes(Long fileSizeInBytes) {
        this.fileSizeInBytes = fileSizeInBytes;
        return this;
    }

    public Integer sessionTimeLimitInSeconds() {
        return this.sessionTimeLimitInSeconds;
    }

    public PacketCaptureSettings withSessionTimeLimitInSeconds(Integer sessionTimeLimitInSeconds) {
        this.sessionTimeLimitInSeconds = sessionTimeLimitInSeconds;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("fileCount", (Number)this.fileCount);
        jsonWriter.writeNumberField("fileSizeInBytes", (Number)this.fileSizeInBytes);
        jsonWriter.writeNumberField("sessionTimeLimitInSeconds", (Number)this.sessionTimeLimitInSeconds);
        return jsonWriter.writeEndObject();
    }

    public static PacketCaptureSettings fromJson(JsonReader jsonReader) throws IOException {
        return (PacketCaptureSettings)jsonReader.readObject(reader -> {
            PacketCaptureSettings deserializedPacketCaptureSettings = new PacketCaptureSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("fileCount".equals(fieldName)) {
                    deserializedPacketCaptureSettings.fileCount = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("fileSizeInBytes".equals(fieldName)) {
                    deserializedPacketCaptureSettings.fileSizeInBytes = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("sessionTimeLimitInSeconds".equals(fieldName)) {
                    deserializedPacketCaptureSettings.sessionTimeLimitInSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPacketCaptureSettings;
        });
    }
}

