/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.EvaluatedNetworkSecurityGroup;
import com.azure.resourcemanager.network.models.SecurityRuleAccess;
import java.io.IOException;
import java.util.List;

public final class NetworkSecurityGroupResult
implements JsonSerializable<NetworkSecurityGroupResult> {
    private SecurityRuleAccess securityRuleAccessResult;
    private List<EvaluatedNetworkSecurityGroup> evaluatedNetworkSecurityGroups;

    public SecurityRuleAccess securityRuleAccessResult() {
        return this.securityRuleAccessResult;
    }

    public NetworkSecurityGroupResult withSecurityRuleAccessResult(SecurityRuleAccess securityRuleAccessResult) {
        this.securityRuleAccessResult = securityRuleAccessResult;
        return this;
    }

    public List<EvaluatedNetworkSecurityGroup> evaluatedNetworkSecurityGroups() {
        return this.evaluatedNetworkSecurityGroups;
    }

    public void validate() {
        if (this.evaluatedNetworkSecurityGroups() != null) {
            this.evaluatedNetworkSecurityGroups().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("securityRuleAccessResult", this.securityRuleAccessResult == null ? null : this.securityRuleAccessResult.toString());
        return jsonWriter.writeEndObject();
    }

    public static NetworkSecurityGroupResult fromJson(JsonReader jsonReader) throws IOException {
        return (NetworkSecurityGroupResult)jsonReader.readObject(reader -> {
            NetworkSecurityGroupResult deserializedNetworkSecurityGroupResult = new NetworkSecurityGroupResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("securityRuleAccessResult".equals(fieldName)) {
                    deserializedNetworkSecurityGroupResult.securityRuleAccessResult = SecurityRuleAccess.fromString(reader.getString());
                    continue;
                }
                if ("evaluatedNetworkSecurityGroups".equals(fieldName)) {
                    List evaluatedNetworkSecurityGroups;
                    deserializedNetworkSecurityGroupResult.evaluatedNetworkSecurityGroups = evaluatedNetworkSecurityGroups = reader.readArray(reader1 -> EvaluatedNetworkSecurityGroup.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedNetworkSecurityGroupResult;
        });
    }
}

