/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.network.fluent.VpnSitesConfigurationsClient;
import com.azure.resourcemanager.network.implementation.NetworkManagementClientImpl;
import com.azure.resourcemanager.network.models.GetVpnSitesConfigurationRequest;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VpnSitesConfigurationsClientImpl
implements VpnSitesConfigurationsClient {
    private final VpnSitesConfigurationsService service;
    private final NetworkManagementClientImpl client;

    VpnSitesConfigurationsClientImpl(NetworkManagementClientImpl client) {
        this.service = (VpnSitesConfigurationsService)RestProxy.create(VpnSitesConfigurationsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> downloadWithResponseAsync(String resourceGroupName, String virtualWanName, GetVpnSitesConfigurationRequest request) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualWanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualWanName is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.download(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualWanName, "2024-05-01", request, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> downloadWithResponseAsync(String resourceGroupName, String virtualWanName, GetVpnSitesConfigurationRequest request, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (virtualWanName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter virtualWanName is required and cannot be null."));
        }
        if (request == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter request is required and cannot be null."));
        }
        request.validate();
        String apiVersion = "2024-05-01";
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.download(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, virtualWanName, "2024-05-01", request, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDownloadAsync(String resourceGroupName, String virtualWanName, GetVpnSitesConfigurationRequest request) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.downloadWithResponseAsync(resourceGroupName, virtualWanName, request);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDownloadAsync(String resourceGroupName, String virtualWanName, GetVpnSitesConfigurationRequest request, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = this.downloadWithResponseAsync(resourceGroupName, virtualWanName, request, context);
        return this.client.getLroResult((Mono)mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDownload(String resourceGroupName, String virtualWanName, GetVpnSitesConfigurationRequest request) {
        return this.beginDownloadAsync(resourceGroupName, virtualWanName, request).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDownload(String resourceGroupName, String virtualWanName, GetVpnSitesConfigurationRequest request, Context context) {
        return this.beginDownloadAsync(resourceGroupName, virtualWanName, request, context).getSyncPoller();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> downloadAsync(String resourceGroupName, String virtualWanName, GetVpnSitesConfigurationRequest request) {
        return this.beginDownloadAsync(resourceGroupName, virtualWanName, request).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> downloadAsync(String resourceGroupName, String virtualWanName, GetVpnSitesConfigurationRequest request, Context context) {
        return this.beginDownloadAsync(resourceGroupName, virtualWanName, request, context).last().flatMap(arg_0 -> ((NetworkManagementClientImpl)this.client).getLroFinalResultOrError(arg_0));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void download(String resourceGroupName, String virtualWanName, GetVpnSitesConfigurationRequest request) {
        this.downloadAsync(resourceGroupName, virtualWanName, request).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void download(String resourceGroupName, String virtualWanName, GetVpnSitesConfigurationRequest request, Context context) {
        this.downloadAsync(resourceGroupName, virtualWanName, request, context).block();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="NetworkManagementCli")
    public static interface VpnSitesConfigurationsService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/virtualWans/{virtualWANName}/vpnConfiguration")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> download(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="virtualWANName") String var4, @QueryParam(value="api-version") String var5, @BodyParam(value="application/json") GetVpnSitesConfigurationRequest var6, @HeaderParam(value="Accept") String var7, Context var8);
    }
}

