/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.implementation;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.resourcemanager.network.fluent.PacketCapturesClient;
import com.azure.resourcemanager.network.fluent.models.PacketCaptureResultInner;
import com.azure.resourcemanager.network.implementation.NetworkWatcherImpl;
import com.azure.resourcemanager.network.implementation.PacketCaptureImpl;
import com.azure.resourcemanager.network.models.PacketCapture;
import com.azure.resourcemanager.network.models.PacketCaptures;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import reactor.core.publisher.Mono;

class PacketCapturesImpl
extends CreatableResourcesImpl<PacketCapture, PacketCaptureImpl, PacketCaptureResultInner>
implements PacketCaptures {
    private final NetworkWatcherImpl parent;
    protected final PacketCapturesClient innerCollection;

    PacketCapturesImpl(PacketCapturesClient innerCollection, NetworkWatcherImpl parent) {
        this.parent = parent;
        this.innerCollection = innerCollection;
    }

    public final PagedIterable<PacketCapture> list() {
        return this.wrapList(this.inner().list(this.parent.resourceGroupName(), this.parent.name()));
    }

    public PagedFlux<PacketCapture> listAsync() {
        return this.wrapPageAsync(this.inner().listAsync(this.parent.resourceGroupName(), this.parent.name()));
    }

    protected PacketCaptureImpl wrapModel(String name) {
        return new PacketCaptureImpl(name, this.parent, new PacketCaptureResultInner(), this.inner());
    }

    protected PacketCaptureImpl wrapModel(PacketCaptureResultInner inner) {
        return inner == null ? null : new PacketCaptureImpl(inner.name(), this.parent, inner, this.inner());
    }

    public PacketCaptureImpl define(String name) {
        return new PacketCaptureImpl(name, this.parent, new PacketCaptureResultInner(), this.inner());
    }

    public Mono<PacketCapture> getByNameAsync(String name) {
        return this.inner().getAsync(this.parent.resourceGroupName(), this.parent.name(), name).map(inner -> this.wrapModel((PacketCaptureResultInner)inner));
    }

    public PacketCapture getByName(String name) {
        return (PacketCapture)this.getByNameAsync(name).block();
    }

    public void deleteByName(String name) {
        this.deleteByNameAsync(name).block();
    }

    public Mono<Void> deleteByNameAsync(String name) {
        return this.inner().deleteAsync(this.parent.resourceGroupName(), this.parent.name(), name);
    }

    public PacketCapturesClient inner() {
        return this.innerCollection;
    }

    public Mono<Void> deleteByIdAsync(String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        return this.inner().deleteAsync(resourceId.resourceGroupName(), resourceId.parent().name(), resourceId.name());
    }
}

