/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.models.CommonTrackedResource;
import com.azure.resourcemanager.network.models.VerifierWorkspaceProperties;
import java.io.IOException;
import java.util.Map;

public final class VerifierWorkspaceInner
extends CommonTrackedResource {
    private VerifierWorkspaceProperties properties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(VerifierWorkspaceInner.class);

    public VerifierWorkspaceProperties properties() {
        return this.properties;
    }

    public VerifierWorkspaceInner withProperties(VerifierWorkspaceProperties properties) {
        this.properties = properties;
        return this;
    }

    @Override
    public SystemData systemData() {
        return this.systemData;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public VerifierWorkspaceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    @Override
    public VerifierWorkspaceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model VerifierWorkspaceInner"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static VerifierWorkspaceInner fromJson(JsonReader jsonReader) throws IOException {
        return (VerifierWorkspaceInner)((Object)jsonReader.readObject(reader -> {
            VerifierWorkspaceInner deserializedVerifierWorkspaceInner = new VerifierWorkspaceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVerifierWorkspaceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVerifierWorkspaceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVerifierWorkspaceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedVerifierWorkspaceInner.withLocation(reader.getString());
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedVerifierWorkspaceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedVerifierWorkspaceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVerifierWorkspaceInner.properties = VerifierWorkspaceProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVerifierWorkspaceInner;
        }));
    }
}

