// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Represents a single NIC configuration properties.
 */
@Fluent
public final class VirtualApplianceNetworkInterfaceConfigurationProperties
    implements JsonSerializable<VirtualApplianceNetworkInterfaceConfigurationProperties> {
    /*
     * The ipConfigurations property.
     */
    private List<VirtualApplianceIpConfiguration> ipConfigurations;

    /**
     * Creates an instance of VirtualApplianceNetworkInterfaceConfigurationProperties class.
     */
    public VirtualApplianceNetworkInterfaceConfigurationProperties() {
    }

    /**
     * Get the ipConfigurations property: The ipConfigurations property.
     * 
     * @return the ipConfigurations value.
     */
    public List<VirtualApplianceIpConfiguration> ipConfigurations() {
        return this.ipConfigurations;
    }

    /**
     * Set the ipConfigurations property: The ipConfigurations property.
     * 
     * @param ipConfigurations the ipConfigurations value to set.
     * @return the VirtualApplianceNetworkInterfaceConfigurationProperties object itself.
     */
    public VirtualApplianceNetworkInterfaceConfigurationProperties
        withIpConfigurations(List<VirtualApplianceIpConfiguration> ipConfigurations) {
        this.ipConfigurations = ipConfigurations;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ipConfigurations() != null) {
            ipConfigurations().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("ipConfigurations", this.ipConfigurations,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualApplianceNetworkInterfaceConfigurationProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualApplianceNetworkInterfaceConfigurationProperties if the JsonReader was pointing to
     * an instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualApplianceNetworkInterfaceConfigurationProperties.
     */
    public static VirtualApplianceNetworkInterfaceConfigurationProperties fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualApplianceNetworkInterfaceConfigurationProperties deserializedVirtualApplianceNetworkInterfaceConfigurationProperties
                = new VirtualApplianceNetworkInterfaceConfigurationProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("ipConfigurations".equals(fieldName)) {
                    List<VirtualApplianceIpConfiguration> ipConfigurations
                        = reader.readArray(reader1 -> VirtualApplianceIpConfiguration.fromJson(reader1));
                    deserializedVirtualApplianceNetworkInterfaceConfigurationProperties.ipConfigurations
                        = ipConfigurations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualApplianceNetworkInterfaceConfigurationProperties;
        });
    }
}
