// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.NetworkManagerInner;
import java.io.IOException;
import java.util.List;

/**
 * Result of the request to list NetworkManager. It contains a list of network managers and a URL link to get the next
 * set of results.
 */
@Fluent
public final class NetworkManagerListResult implements JsonSerializable<NetworkManagerListResult> {
    /*
     * Gets a page of NetworkManager
     */
    private List<NetworkManagerInner> value;

    /*
     * Gets the URL to get the next page of results.
     */
    private String nextLink;

    /**
     * Creates an instance of NetworkManagerListResult class.
     */
    public NetworkManagerListResult() {
    }

    /**
     * Get the value property: Gets a page of NetworkManager.
     * 
     * @return the value value.
     */
    public List<NetworkManagerInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Gets a page of NetworkManager.
     * 
     * @param value the value value to set.
     * @return the NetworkManagerListResult object itself.
     */
    public NetworkManagerListResult withValue(List<NetworkManagerInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Gets the URL to get the next page of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Gets the URL to get the next page of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the NetworkManagerListResult object itself.
     */
    public NetworkManagerListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkManagerListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkManagerListResult if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkManagerListResult.
     */
    public static NetworkManagerListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkManagerListResult deserializedNetworkManagerListResult = new NetworkManagerListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<NetworkManagerInner> value
                        = reader.readArray(reader1 -> NetworkManagerInner.fromJson(reader1));
                    deserializedNetworkManagerListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedNetworkManagerListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkManagerListResult;
        });
    }
}
