// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

/**
 * Network Manager Deployment Status.
 */
@Fluent
public final class NetworkManagerDeploymentStatus implements JsonSerializable<NetworkManagerDeploymentStatus> {
    /*
     * Commit Time.
     */
    private OffsetDateTime commitTime;

    /*
     * Region Name.
     */
    private String region;

    /*
     * Deployment Status.
     */
    private DeploymentStatus deploymentStatus;

    /*
     * List of configuration ids.
     */
    private List<String> configurationIds;

    /*
     * Configuration Deployment Type.
     */
    private ConfigurationType deploymentType;

    /*
     * Error Message.
     */
    private String errorMessage;

    /**
     * Creates an instance of NetworkManagerDeploymentStatus class.
     */
    public NetworkManagerDeploymentStatus() {
    }

    /**
     * Get the commitTime property: Commit Time.
     * 
     * @return the commitTime value.
     */
    public OffsetDateTime commitTime() {
        return this.commitTime;
    }

    /**
     * Set the commitTime property: Commit Time.
     * 
     * @param commitTime the commitTime value to set.
     * @return the NetworkManagerDeploymentStatus object itself.
     */
    public NetworkManagerDeploymentStatus withCommitTime(OffsetDateTime commitTime) {
        this.commitTime = commitTime;
        return this;
    }

    /**
     * Get the region property: Region Name.
     * 
     * @return the region value.
     */
    public String region() {
        return this.region;
    }

    /**
     * Set the region property: Region Name.
     * 
     * @param region the region value to set.
     * @return the NetworkManagerDeploymentStatus object itself.
     */
    public NetworkManagerDeploymentStatus withRegion(String region) {
        this.region = region;
        return this;
    }

    /**
     * Get the deploymentStatus property: Deployment Status.
     * 
     * @return the deploymentStatus value.
     */
    public DeploymentStatus deploymentStatus() {
        return this.deploymentStatus;
    }

    /**
     * Set the deploymentStatus property: Deployment Status.
     * 
     * @param deploymentStatus the deploymentStatus value to set.
     * @return the NetworkManagerDeploymentStatus object itself.
     */
    public NetworkManagerDeploymentStatus withDeploymentStatus(DeploymentStatus deploymentStatus) {
        this.deploymentStatus = deploymentStatus;
        return this;
    }

    /**
     * Get the configurationIds property: List of configuration ids.
     * 
     * @return the configurationIds value.
     */
    public List<String> configurationIds() {
        return this.configurationIds;
    }

    /**
     * Set the configurationIds property: List of configuration ids.
     * 
     * @param configurationIds the configurationIds value to set.
     * @return the NetworkManagerDeploymentStatus object itself.
     */
    public NetworkManagerDeploymentStatus withConfigurationIds(List<String> configurationIds) {
        this.configurationIds = configurationIds;
        return this;
    }

    /**
     * Get the deploymentType property: Configuration Deployment Type.
     * 
     * @return the deploymentType value.
     */
    public ConfigurationType deploymentType() {
        return this.deploymentType;
    }

    /**
     * Set the deploymentType property: Configuration Deployment Type.
     * 
     * @param deploymentType the deploymentType value to set.
     * @return the NetworkManagerDeploymentStatus object itself.
     */
    public NetworkManagerDeploymentStatus withDeploymentType(ConfigurationType deploymentType) {
        this.deploymentType = deploymentType;
        return this;
    }

    /**
     * Get the errorMessage property: Error Message.
     * 
     * @return the errorMessage value.
     */
    public String errorMessage() {
        return this.errorMessage;
    }

    /**
     * Set the errorMessage property: Error Message.
     * 
     * @param errorMessage the errorMessage value to set.
     * @return the NetworkManagerDeploymentStatus object itself.
     */
    public NetworkManagerDeploymentStatus withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("commitTime",
            this.commitTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.commitTime));
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeStringField("deploymentStatus",
            this.deploymentStatus == null ? null : this.deploymentStatus.toString());
        jsonWriter.writeArrayField("configurationIds", this.configurationIds,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("deploymentType",
            this.deploymentType == null ? null : this.deploymentType.toString());
        jsonWriter.writeStringField("errorMessage", this.errorMessage);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of NetworkManagerDeploymentStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of NetworkManagerDeploymentStatus if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the NetworkManagerDeploymentStatus.
     */
    public static NetworkManagerDeploymentStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            NetworkManagerDeploymentStatus deserializedNetworkManagerDeploymentStatus
                = new NetworkManagerDeploymentStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("commitTime".equals(fieldName)) {
                    deserializedNetworkManagerDeploymentStatus.commitTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("region".equals(fieldName)) {
                    deserializedNetworkManagerDeploymentStatus.region = reader.getString();
                } else if ("deploymentStatus".equals(fieldName)) {
                    deserializedNetworkManagerDeploymentStatus.deploymentStatus
                        = DeploymentStatus.fromString(reader.getString());
                } else if ("configurationIds".equals(fieldName)) {
                    List<String> configurationIds = reader.readArray(reader1 -> reader1.getString());
                    deserializedNetworkManagerDeploymentStatus.configurationIds = configurationIds;
                } else if ("deploymentType".equals(fieldName)) {
                    deserializedNetworkManagerDeploymentStatus.deploymentType
                        = ConfigurationType.fromString(reader.getString());
                } else if ("errorMessage".equals(fieldName)) {
                    deserializedNetworkManagerDeploymentStatus.errorMessage = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNetworkManagerDeploymentStatus;
        });
    }
}
