// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Public IP addresses associated with azure firewall.
 */
@Fluent
public final class HubPublicIpAddresses implements JsonSerializable<HubPublicIpAddresses> {
    /*
     * The list of Public IP addresses associated with azure firewall or IP addresses to be retained.
     */
    private List<AzureFirewallPublicIpAddress> addresses;

    /*
     * The number of Public IP addresses associated with azure firewall.
     */
    private Integer count;

    /**
     * Creates an instance of HubPublicIpAddresses class.
     */
    public HubPublicIpAddresses() {
    }

    /**
     * Get the addresses property: The list of Public IP addresses associated with azure firewall or IP addresses to be
     * retained.
     * 
     * @return the addresses value.
     */
    public List<AzureFirewallPublicIpAddress> addresses() {
        return this.addresses;
    }

    /**
     * Set the addresses property: The list of Public IP addresses associated with azure firewall or IP addresses to be
     * retained.
     * 
     * @param addresses the addresses value to set.
     * @return the HubPublicIpAddresses object itself.
     */
    public HubPublicIpAddresses withAddresses(List<AzureFirewallPublicIpAddress> addresses) {
        this.addresses = addresses;
        return this;
    }

    /**
     * Get the count property: The number of Public IP addresses associated with azure firewall.
     * 
     * @return the count value.
     */
    public Integer count() {
        return this.count;
    }

    /**
     * Set the count property: The number of Public IP addresses associated with azure firewall.
     * 
     * @param count the count value to set.
     * @return the HubPublicIpAddresses object itself.
     */
    public HubPublicIpAddresses withCount(Integer count) {
        this.count = count;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (addresses() != null) {
            addresses().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("addresses", this.addresses, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeNumberField("count", this.count);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HubPublicIpAddresses from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HubPublicIpAddresses if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the HubPublicIpAddresses.
     */
    public static HubPublicIpAddresses fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HubPublicIpAddresses deserializedHubPublicIpAddresses = new HubPublicIpAddresses();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("addresses".equals(fieldName)) {
                    List<AzureFirewallPublicIpAddress> addresses
                        = reader.readArray(reader1 -> AzureFirewallPublicIpAddress.fromJson(reader1));
                    deserializedHubPublicIpAddresses.addresses = addresses;
                } else if ("count".equals(fieldName)) {
                    deserializedHubPublicIpAddresses.count = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHubPublicIpAddresses;
        });
    }
}
