// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The current status of the connection.
 */
public final class FailoverConnectionStatus extends ExpandableStringEnum<FailoverConnectionStatus> {
    /**
     * Static value Connected for FailoverConnectionStatus.
     */
    public static final FailoverConnectionStatus CONNECTED = fromString("Connected");

    /**
     * Static value Disconnected for FailoverConnectionStatus.
     */
    public static final FailoverConnectionStatus DISCONNECTED = fromString("Disconnected");

    /**
     * Creates a new instance of FailoverConnectionStatus value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public FailoverConnectionStatus() {
    }

    /**
     * Creates or finds a FailoverConnectionStatus from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding FailoverConnectionStatus.
     */
    public static FailoverConnectionStatus fromString(String name) {
        return fromString(name, FailoverConnectionStatus.class);
    }

    /**
     * Gets known FailoverConnectionStatus values.
     * 
     * @return known FailoverConnectionStatus values.
     */
    public static Collection<FailoverConnectionStatus> values() {
        return values(FailoverConnectionStatus.class);
    }
}
