// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains bandwidths offered in ExpressRouteServiceProvider resources.
 */
@Fluent
public final class ExpressRouteServiceProviderBandwidthsOffered
    implements JsonSerializable<ExpressRouteServiceProviderBandwidthsOffered> {
    /*
     * The OfferName.
     */
    private String offerName;

    /*
     * The ValueInMbps.
     */
    private Integer valueInMbps;

    /**
     * Creates an instance of ExpressRouteServiceProviderBandwidthsOffered class.
     */
    public ExpressRouteServiceProviderBandwidthsOffered() {
    }

    /**
     * Get the offerName property: The OfferName.
     * 
     * @return the offerName value.
     */
    public String offerName() {
        return this.offerName;
    }

    /**
     * Set the offerName property: The OfferName.
     * 
     * @param offerName the offerName value to set.
     * @return the ExpressRouteServiceProviderBandwidthsOffered object itself.
     */
    public ExpressRouteServiceProviderBandwidthsOffered withOfferName(String offerName) {
        this.offerName = offerName;
        return this;
    }

    /**
     * Get the valueInMbps property: The ValueInMbps.
     * 
     * @return the valueInMbps value.
     */
    public Integer valueInMbps() {
        return this.valueInMbps;
    }

    /**
     * Set the valueInMbps property: The ValueInMbps.
     * 
     * @param valueInMbps the valueInMbps value to set.
     * @return the ExpressRouteServiceProviderBandwidthsOffered object itself.
     */
    public ExpressRouteServiceProviderBandwidthsOffered withValueInMbps(Integer valueInMbps) {
        this.valueInMbps = valueInMbps;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("offerName", this.offerName);
        jsonWriter.writeNumberField("valueInMbps", this.valueInMbps);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ExpressRouteServiceProviderBandwidthsOffered from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ExpressRouteServiceProviderBandwidthsOffered if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ExpressRouteServiceProviderBandwidthsOffered.
     */
    public static ExpressRouteServiceProviderBandwidthsOffered fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ExpressRouteServiceProviderBandwidthsOffered deserializedExpressRouteServiceProviderBandwidthsOffered
                = new ExpressRouteServiceProviderBandwidthsOffered();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("offerName".equals(fieldName)) {
                    deserializedExpressRouteServiceProviderBandwidthsOffered.offerName = reader.getString();
                } else if ("valueInMbps".equals(fieldName)) {
                    deserializedExpressRouteServiceProviderBandwidthsOffered.valueInMbps
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedExpressRouteServiceProviderBandwidthsOffered;
        });
    }
}
