// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * BGP peer status details.
 */
@Immutable
public final class BgpPeerStatus implements JsonSerializable<BgpPeerStatus> {
    /*
     * The virtual network gateway's local address.
     */
    private String localAddress;

    /*
     * The remote BGP peer.
     */
    private String neighbor;

    /*
     * The autonomous system number of the remote BGP peer.
     */
    private Long asn;

    /*
     * The BGP peer state.
     */
    private BgpPeerState state;

    /*
     * For how long the peering has been up.
     */
    private String connectedDuration;

    /*
     * The number of routes learned from this peer.
     */
    private Long routesReceived;

    /*
     * The number of BGP messages sent.
     */
    private Long messagesSent;

    /*
     * The number of BGP messages received.
     */
    private Long messagesReceived;

    /**
     * Creates an instance of BgpPeerStatus class.
     */
    public BgpPeerStatus() {
    }

    /**
     * Get the localAddress property: The virtual network gateway's local address.
     * 
     * @return the localAddress value.
     */
    public String localAddress() {
        return this.localAddress;
    }

    /**
     * Get the neighbor property: The remote BGP peer.
     * 
     * @return the neighbor value.
     */
    public String neighbor() {
        return this.neighbor;
    }

    /**
     * Get the asn property: The autonomous system number of the remote BGP peer.
     * 
     * @return the asn value.
     */
    public Long asn() {
        return this.asn;
    }

    /**
     * Get the state property: The BGP peer state.
     * 
     * @return the state value.
     */
    public BgpPeerState state() {
        return this.state;
    }

    /**
     * Get the connectedDuration property: For how long the peering has been up.
     * 
     * @return the connectedDuration value.
     */
    public String connectedDuration() {
        return this.connectedDuration;
    }

    /**
     * Get the routesReceived property: The number of routes learned from this peer.
     * 
     * @return the routesReceived value.
     */
    public Long routesReceived() {
        return this.routesReceived;
    }

    /**
     * Get the messagesSent property: The number of BGP messages sent.
     * 
     * @return the messagesSent value.
     */
    public Long messagesSent() {
        return this.messagesSent;
    }

    /**
     * Get the messagesReceived property: The number of BGP messages received.
     * 
     * @return the messagesReceived value.
     */
    public Long messagesReceived() {
        return this.messagesReceived;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BgpPeerStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BgpPeerStatus if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the BgpPeerStatus.
     */
    public static BgpPeerStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BgpPeerStatus deserializedBgpPeerStatus = new BgpPeerStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("localAddress".equals(fieldName)) {
                    deserializedBgpPeerStatus.localAddress = reader.getString();
                } else if ("neighbor".equals(fieldName)) {
                    deserializedBgpPeerStatus.neighbor = reader.getString();
                } else if ("asn".equals(fieldName)) {
                    deserializedBgpPeerStatus.asn = reader.getNullable(JsonReader::getLong);
                } else if ("state".equals(fieldName)) {
                    deserializedBgpPeerStatus.state = BgpPeerState.fromString(reader.getString());
                } else if ("connectedDuration".equals(fieldName)) {
                    deserializedBgpPeerStatus.connectedDuration = reader.getString();
                } else if ("routesReceived".equals(fieldName)) {
                    deserializedBgpPeerStatus.routesReceived = reader.getNullable(JsonReader::getLong);
                } else if ("messagesSent".equals(fieldName)) {
                    deserializedBgpPeerStatus.messagesSent = reader.getNullable(JsonReader::getLong);
                } else if ("messagesReceived".equals(fieldName)) {
                    deserializedBgpPeerStatus.messagesReceived = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBgpPeerStatus;
        });
    }
}
