// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.network.fluent.models.ApplicationGatewayInner;
import java.io.IOException;
import java.util.List;

/**
 * Response for ListApplicationGateways API service call.
 */
@Fluent
public final class ApplicationGatewayListResult implements JsonSerializable<ApplicationGatewayListResult> {
    /*
     * List of an application gateways in a resource group.
     */
    private List<ApplicationGatewayInner> value;

    /*
     * URL to get the next set of results.
     */
    private String nextLink;

    /**
     * Creates an instance of ApplicationGatewayListResult class.
     */
    public ApplicationGatewayListResult() {
    }

    /**
     * Get the value property: List of an application gateways in a resource group.
     * 
     * @return the value value.
     */
    public List<ApplicationGatewayInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of an application gateways in a resource group.
     * 
     * @param value the value value to set.
     * @return the ApplicationGatewayListResult object itself.
     */
    public ApplicationGatewayListResult withValue(List<ApplicationGatewayInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL to get the next set of results.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of results.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ApplicationGatewayListResult object itself.
     */
    public ApplicationGatewayListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApplicationGatewayListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApplicationGatewayListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApplicationGatewayListResult.
     */
    public static ApplicationGatewayListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApplicationGatewayListResult deserializedApplicationGatewayListResult = new ApplicationGatewayListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ApplicationGatewayInner> value
                        = reader.readArray(reader1 -> ApplicationGatewayInner.fromJson(reader1));
                    deserializedApplicationGatewayListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedApplicationGatewayListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApplicationGatewayListResult;
        });
    }
}
